<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class SendMessageEvent implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    protected $message;
    public function __construct($message)
    {
        $this->message=$message;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
     */
    public function broadcastOn()
    {
//        dd($this->message->shipment_id);
//        return new Channel('message-'.$this->message->replacement_id);
        return new Channel('message-'.$this->message->shipment_id);
    }
    public function broadcastWith()
    {
        $data['message']=$this->message;
//        $data['message']['media']=$this->message->image ? $this->message->image : '' ;
//        $data['message']['sender']=  $this->message->sender;
//        $data['message']['sender']['image'] = $this->message->sender->image() ? $this->message->sender->image() : null ;
//        $data['message']['receiver']=$this->message->receiver;
        return $data;
    }
}
