<?php

namespace App\Events;

use App\Http\Resources\DriverShipmentResource;
use App\Models\AppSetting;
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class SendShipmentEvent implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    protected $shipment;
    protected $driverId;
    protected $status;
    public function __construct($shipment,$driverId,$status = 'new-shipment')
    {
        $this->shipment=$shipment;
        $this->driverId=$driverId;
        $this->status=$status;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
     */
    public function broadcastOn()
    {

        return new Channel('shipments-'.$this->driverId);
    }
    public function broadcastWith()
    {
        $shipment['id']=$this->shipment->id;
        $shipment['status']=$this->status;
        $shipment['reciever_name'] = $this->shipment->receiver->name;
        $shipment['reciever_image'] = asset('images/') . '/' .$this->shipment->receiver?->image;
        $shipment['reciever_rate'] =$this->shipment->receiver?->rate;
        $shipment['price'] = $this->shipment->user_price ?? 0;
        $shipment['packing_from_name'] = $this->shipment->from_address_details?->address_name . '(' . $this->shipment->from_address_details?->country?->name_ar . ')';
        $shipment['packing_from'] = $this->shipment->from_address_details?->street_name . " - " . $this->shipment->from_address_details?->city?->name_ar . " - " . $this->shipment->from_address_details?->governorate?->name_ar . " - " . $this->shipment->from_address_details?->country?->name_ar;
        $shipment['packing_to_name'] = $this->shipment->to_address_details?->address_name . '(' . $this->shipment->to_address_details->country?->name_ar . ')';
        $shipment['packing_to'] =$this->shipment->to_address_details?->street_name . " - " . $this->shipment->to_address_details->city?->name_ar . " - " . $this->shipment->to_address_details->governorate?->name_ar . " - " . $this->shipment->to_address_details->country?->name_ar;
        $shipment['packing_date'] = $this->shipment->packing_date . " - " . $this->shipment->packing_time;
        $shipment['driver_limit_price_percentage'] = AppSetting::key('user_limit_price_percentage')->first()->value;
        return $shipment;


    }
}
