<?php

namespace App\Exports;

use App\Models\AppSetting;
use App\Models\Shipment;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\WithColumnWidths;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Events\AfterSheet;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use Spatie\Permission\Models\Permission;
use Carbon\Carbon;

class ReportsExport implements FromView, WithStyles, WithColumnWidths, WithEvents
{

    public function view(): View
    {
        $from=Carbon::parse(request('from'))->toDateString();
        $to=Carbon::parse(request('to'))->toDateString()??Carbon::now()->toDateString();

        $shipmentQuery = Shipment::orderBy('created_at', 'desc')
            ->when(request()->user_id,function ($query){
                $query->where('sender_id',request()->user_id);
            })
            ->when(request()->status,function ($query){
                $query->where('status',request()->status);
            })
            ->when(request()->id,function ($query){
                $query->where('id',request()->id);
            })
            ->when(request()->driver_id,function ($query){
                $query->whereHas('drivers',function ($query){
                    $query->where(['shipment_drivers.driver_id'=>request()->driver_id,'shipment_drivers.status'=>1]);
                });
            })
            ->when(request()->from && request()->to,function ($query)use($from,$to){
                $query->whereBetween('created_at',[$from,$to]);
            })
            ->whereHas('drivers');
        $shipments = $shipmentQuery->paginate();

        $shipmentPrices=$shipmentQuery->sum('final_price');
        $shipmentCount = $shipmentQuery->count();
        $numberOfTrucks=$shipmentQuery->sum('number_of_trucks');


        $appAndTaxPrices = Shipment::with(['drivers' => function($query) {
            $query->select('shipment_drivers.id', 'shipment_drivers.shipment_id')
                ->selectRaw('SUM(shipment_drivers.app_price) as total_app_price')
                ->selectRaw('SUM(shipment_drivers.tax) as total_tax')
                ->groupBy('shipment_drivers.shipment_id', 'shipment_drivers.id');
        }])->get();

// To get the totals

        $appPrices=$appAndTaxPrices->pluck('drivers')->flatten()->sum('pivot.total_app_price');
        $taxPrices=$appAndTaxPrices->pluck('drivers')->flatten()->sum('pivot.total_tax');
        $driverPrices=($shipmentPrices * ((100-AppSetting::key('app_percentage')->first()->value)/100))-$appPrices-$taxPrices;

        return view('admin.pages.reports.excel-view', compact('shipments','shipmentPrices','shipmentCount','numberOfTrucks','appPrices',
            'taxPrices','driverPrices'
        ));







    }

    public function styles(Worksheet $sheet)
    {

//        return [
//            // Style the first row as bold text.
//            1    => ['font' => ['bold' => true,'italic' => true,'size' => 12]],
//
//            // Styling a specific cell by coordinate.
//        ];
//        $sheet->getStyle(1)->getFont()->setBold(true);
//        $sheet->getStyle(1)->getAlignment()->setHorizontal('center');
//        $sheet->getStyle(1)->getFont()->setColor(new \PhpOffice\PhpSpreadsheet\Style\Color( \PhpOffice\PhpSpreadsheet\Style\Color::COLOR_DARKRED ));
//        $sheet->getStyle(1) ->getFill() ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_PATTERN_DARKGRAY)
//            ;;
//        $sheet->getStyle(1)->getFont()->setSize(12);
//        $sheet->getStyle(1)->getFont()->setUnderline(true);
        //        $sheet->getStyle('B')->getFont()->setSize(12);
//        $sheet->getStyle('C')->getFont()->setSize(12);
//        $sheet->getStyle('D')->getFont()->setSize(12);


    }

    public function registerEvents(): array

    {

        return [

            AfterSheet::class => function (AfterSheet $event) {

                $event->sheet->getDelegate()->getParent()->getDefaultStyle()->getFont()->setName('MS P Gothic');

            },

        ];

    }

    public function columnWidths(): array
    {
        return [
            'A' => 15,
            'B' => 15,
            'C' => 15,
            'D' => 30,
            'E' => 15,
            'F' => 15,
            'G' => 15,
            'H' => 20,
            'I' => 20,
            'J' => 20,
            'K' => 20,
            'L' => 20,
            'M' => 20,
            'N' => 20,
            'O' => 20,
            'P' => 20,
            'Q' => 20,
            'R' => 20,
            'S' => 20,
            'T' => 20,
            'U' => 20,
            'V' => 20,
            'W' => 20,
            'X' => 20,
            'Y' => 20,
            'z' => 20,
        ];
    }
}
