<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\DriversRequest;
use App\Models\Country;
use App\Models\Driver;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Hash;

class DriversController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        abort_if(Gate::denies('access_drivers'), 403);
        $from=Carbon::parse($request->from)->toDateString();
        $to=Carbon::parse($request->to)->toDateString()??Carbon::now()->toDateString();

        $drivers=Driver::orderBy('created_at','desc')
            ->when(request()->accepted,function ($query){
                $query->where('accepted',0);
            })
            ->when(!request()->accepted,function ($query){
                $query->where('accepted',1);
            })
            ->when($request->from && $request->to,function ($query)use($from,$to){
                $query->whereBetween('created_at',[$from,$to]);
            })

            ->paginate();
        if(request()->accepted){
            return view('admin.pages.drivers.requests',compact('drivers'));

        }
        return view('admin.pages.drivers.index',compact('drivers'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $driver=Driver::whereId($id)->with('shipments')->first();
        return view('admin.pages.drivers.show',compact('driver'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
//        abort_if(Gate::denies('edit_users'), 403);
        abort_if(Gate::denies('edit_drivers'), 403);

        $driver=Driver::whereId($id)->first();
        $countries=Country::all();
        return view('admin.pages.drivers.edit',compact('driver','countries'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(DriversRequest $request, $id)
    {
        abort_if(Gate::denies('edit_drivers'), 403);

        $driver=Driver::whereId($id)->first();

        if($request->hasFile('profile_image')){

            $profile_image = $request->file('profile_image');
            $profile_image_name = time() . '-' . $profile_image->getClientOriginalName();
            $profile_image->move(public_path().'/images/drivers', $profile_image_name);
            $driver->update(['profile_image' => $profile_image_name]);

        }

        if($request->hasFile('front_identity_card_image') && $request->hasFile('back_identity_card_image')){

            $front_identity_card_image = $request->file('front_identity_card_image');
            $front_file_name = time() . '-' . $front_identity_card_image->getClientOriginalName();
            $front_identity_card_image->move(public_path().'/images/drivers/front_identity_card_image', $front_file_name);

            $back_identity_card_image = $request->file('back_identity_card_image');
            $back_file_name = time() . '-' . $back_identity_card_image->getClientOriginalName();
            $back_identity_card_image->move(public_path().'/images/drivers/back_identity_card_image', $back_file_name);
            $driver->update(['front_identity_card_image' => $front_file_name ,'back_identity_card_image' => $back_file_name]);

        }

        if($request->hasFile('passport_image')){

            $passport_image = $request->file('passport_image');
            $passport_image_name = time() . '-' . $passport_image->getClientOriginalName();
            $passport_image->move(public_path().'/images/drivers/passport_image', $passport_image_name);
            $driver->update(['passport_image' => $passport_image_name]);

        }

        if($request->hasFile('other_identity_image')){

            $other_identity_image = $request->file('other_identity_image');
            $other_identity_image_name = time() . '-' . $other_identity_image->getClientOriginalName();
            $other_identity_image->move(public_path().'/images/drivers/other_identity_image', $other_identity_image_name);

            $driver->update(['other_identity_image' => $other_identity_image_name]);

        }
        if($request->hasFile('front_license_image')){

            $front_license_image = $request->file('front_license_image');
            $front_license_image_name = time() . '-' . $front_license_image->getClientOriginalName();
            $front_license_image->move(public_path().'/images/drivers/front_license_image', $front_license_image_name);
            $driver->update(['front_license_image' => $front_license_image_name]);

        }
        if($request->hasFile('back_license_image')){

            $back_license_image = $request->file('back_license_image');
            $back_license_image_name = time() . '-' . $back_license_image->getClientOriginalName();
            $back_license_image->move(public_path().'/images/drivers/back_license_image', $back_license_image_name);
            $driver->update(['back_license_image'=>$back_license_image_name]);

        }
        if($request->hasFile('front_ownership_image')){

            $front_ownership_image = $request->file('front_ownership_image');
            $front_ownership_image_name = time() . '-' . $front_ownership_image->getClientOriginalName();
            $front_ownership_image->move(public_path().'/images/drivers/front_ownership_image', $front_ownership_image_name);
            $driver->update(['front_ownership_image'=>$front_ownership_image_name]);

        }
        if($request->hasFile('back_ownership_image')){

            $back_ownership_image = $request->file('back_ownership_image');
            $back_ownership_image_name = time() . '-' . $back_ownership_image->getClientOriginalName();
            $back_ownership_image->move(public_path().'/images/drivers/back_ownership_image', $back_ownership_image_name);
            $driver->update(['back_ownership_image'=>$back_ownership_image_name]);

        }


        $driver->update($request->validated());
        if($request->password!=null){
            $driver->update(['password'=>Hash::make($request->password)]);
        }

        return redirect()->route('admin.drivers.index')->with('success','Update');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
//        abort_if(Gate::denies('delete_users'), 403);
        abort_if(Gate::denies('delete_drivers'), 403);

        $driver=Driver::whereId($id)->first();

        $driver->delete();

        return redirect()->route('admin.drivers.index')->with('success','Deleted');

    }
    public function status($id)
    {

        $driver=Driver::whereId($id)->first();
        $driver->update([
            'status'=>$driver->status==1?2:1
        ]);

        return redirect()->route('admin.drivers.index')->with('success','Deleted');

    }
    public function accept($id)
    {

        $driver=Driver::whereId($id)->first();
        $driver->update([
            'accepted'=>1
        ]);

        return redirect()->route('admin.drivers.index')->with('success','Accepted');

    }
    public function rates($driver_id)
    {
        $rates=Driver::whereId($driver_id)->first()->rates()->paginate();
        return view('admin.pages.drivers.rates',compact('rates'));

    }

}
