<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\RoleRequest;
use App\Http\Controllers\Controller;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RolesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $roles = Role::with(['permissions' => function ($query) {
            $query->select('name')->take(15)->get();
        }])
            ->where('name', '!=', 'Super Admin')
            ->where('guard_name','admin')
            ->get();
        return view('admin.pages.roles.index',compact('roles'));
    }

    public function create()
    {

        return view('admin.pages.roles.create');
    }

    public function store(RoleRequest $request)
    {

        $role = Role::create([
            'name' => $request->name
        ]);

        $role->givePermissionTo($request->permissions);

        return redirect()->route('admin.roles.index')->with('success', __('Role added successfully'));
    }

    public function edit(Role $role)
    {
        return view('admin.pages.roles.edit', compact('role'));
    }


    public function update(RoleRequest $request, Role $role)
    {

        $role->update([
            'name' => $request->name
        ]);

        $role->syncPermissions($request->permissions);

        return redirect()->route('admin.roles.index')->with('success', __('Role updated successfully'));
    }

    public function destroy(Role $role)
    {

        $role->delete();

        return back()->with('success', __('Role deleted successfully'));
    }

}
