<?php

namespace App\Http\Controllers\Admin;

use App\Models\ShipmentGovernorate;
use Illuminate\Http\Request;
use App\Models\ShipmentCity;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\CitiesRequest;

class ShipmentCitiesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
//        abort_if(Gate::denies('all_suggestions'), 403);

        $shipmentCities = ShipmentCity::orderBy('created_at', 'desc')->whereHas('governorate')
            ->when($request->governorate_id,function ($query)use ($request){
                $query->where('shipment_governorate_id',$request->governorate_id);
            })

            ->paginate();
        return view('admin.pages.shipment-city.index', compact('shipmentCities'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $governorates=ShipmentGovernorate::all();

        return view('admin.pages.shipment-city.create',compact('governorates'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(CitiesRequest $request)
    {
        ShipmentCity::create($request->validated() );


        return redirect()->route('admin.shipment-city.index')->with('success', 'Added');
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $shipmentCity = ShipmentCity::whereId($id)->first();
        $governorates=ShipmentGovernorate::all();

        return view('admin.pages.shipment-city.edit', compact('shipmentCity','governorates'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(CitiesRequest $request, $id)
    {
        $shipmentCity = ShipmentCity::whereId($id)->first();
        $shipmentCity->update($request->validated());

       return redirect()->back()->with('success', 'Updated');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
//        abort_if(Gate::denies('delete_suggestions'), 403);

        $shipmentCity = ShipmentCity::whereId($id)->first();
        $shipmentCity->delete();
        return redirect()->route('admin.shipment-city.index')->with('success', 'Deleted');

    }
}
