<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\TruckCategoriesRequest;
use App\Models\TruckCategory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use App\Http\Controllers\Controller;

class TruckCategoriesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
//        abort_if(Gate::denies('all_suggestions'), 403);

        $truckCategories = TruckCategory::orderBy('created_at', 'desc')->paginate();
        return view('admin.pages.truck-categories.index', compact('truckCategories'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.pages.truck-categories.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(TruckCategoriesRequest $request)
    {
        TruckCategory::create($request->validated());


        return redirect()->route('admin.truck-categories.index')->with('success', 'Added');
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $truckCategory = TruckCategory::whereId($id)->first();
        return view('admin.pages.truck-categories.edit', compact('truckCategory'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update( TruckCategoriesRequest $request, $id)
    {
        $truckCategory = TruckCategory::whereId($id)->first();
        $truckCategory->update($request->validated());

       return redirect()->back()->with('success', 'Updated');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
//        abort_if(Gate::denies('delete_suggestions'), 403);

        $truckCategory = TruckCategory::whereId($id)->first();
        $truckCategory->delete();
        return redirect()->route('admin.truck-categories.index')->with('success', 'Deleted');

    }
}
