<?php

namespace App\Http\Controllers\Admin;
use App\Http\Requests\Admin\TruckHeightsRequest;
use App\Http\Requests\Admin\TruckModelsRequest;
use App\Models\TruckHeight;
use App\Models\TruckModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use App\Http\Controllers\Controller;

class TruckHeightsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
//        abort_if(Gate::denies('all_suggestions'), 403);

        $truckHeights = TruckHeight::orderBy('created_at', 'desc')->paginate();
        return view('admin.pages.truck-heights.index', compact('truckHeights'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.pages.truck-heights.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(TruckHeightsRequest $request)
    {
        TruckHeight::create($request->validated());


        return redirect()->route('admin.truck-heights.index')->with('success', 'Added');
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $truckHeight = TruckHeight::whereId($id)->first();
        return view('admin.pages.truck-heights.edit', compact('truckHeight'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update( TruckHeightsRequest $request, $id)
    {
        $truckHeight = TruckHeight::whereId($id)->first();
        $truckHeight->update($request->validated());

       return redirect()->back()->with('success', 'Updated');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
//        abort_if(Gate::denies('delete_suggestions'), 403);

        $truckHeight = TruckHeight::whereId($id)->first();
        $truckHeight->delete();
        return redirect()->route('admin.truck-heights.index')->with('success', 'Deleted');

    }
}
