<?php

namespace App\Http\Controllers\Admin;
use App\Http\Requests\Admin\TruckLengthsRequest;
use App\Models\TruckLength;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class TruckLengthsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
//        abort_if(Gate::denies('all_suggestions'), 403);

        $truckLengths = TruckLength::orderBy('created_at', 'desc')->paginate();
        return view('admin.pages.truck-lengths.index', compact('truckLengths'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.pages.truck-lengths.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(TruckLengthsRequest $request)
    {
        TruckLength::create($request->validated());
        return redirect()->route('admin.truck-lengths.index')->with('success', 'Added');
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $truckLength = TruckLength::whereId($id)->first();
        return view('admin.pages.truck-lengths.edit', compact('truckLength'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update( TruckLengthsRequest $request, $id)
    {
        $truckLength = TruckLength::whereId($id)->first();
        $truckLength->update($request->validated());
       return redirect()->back()->with('success', 'Updated');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
//        abort_if(Gate::denies('delete_suggestions'), 403);

        $truckLength = TruckLength::whereId($id)->first();
        $truckLength->delete();
        return redirect()->route('admin.truck-lengths.index')->with('success', 'Deleted');

    }
}
