<?php

namespace App\Http\Controllers\Admin;
use App\Http\Requests\Admin\TruckLoadCapacitiesRequest;
use App\Models\TruckLoadCapacity;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class TruckLoadCapacitiesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
//        abort_if(Gate::denies('all_suggestions'), 403);

        $truckLoadCapacities = TruckLoadCapacity::orderBy('created_at', 'desc')->paginate();
        return view('admin.pages.truck-load-capacities.index', compact('truckLoadCapacities'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.pages.truck-load-capacities.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(TruckLoadCapacitiesRequest $request)
    {
        TruckLoadCapacity::create($request->validated());
        return redirect()->route('admin.truck-load-capacities.index')->with('success', 'Added');
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $truckLoadCapacity = TruckLoadCapacity::whereId($id)->first();
        return view('admin.pages.truck-load-capacities.edit', compact('truckLoadCapacity'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update( TruckLoadCapacitiesRequest $request, $id)
    {
        $truckLoadCapacity = TruckLoadCapacity::whereId($id)->first();
        $truckLoadCapacity->update($request->validated());
       return redirect()->back()->with('success', 'Updated');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
//        abort_if(Gate::denies('delete_suggestions'), 403);

        $truckLoadCapacity = TruckLoadCapacity::whereId($id)->first();
        $truckLoadCapacity->delete();
        return redirect()->route('admin.truck-load-capacities.index')->with('success', 'Deleted');

    }
}
