<?php

namespace App\Http\Controllers\Admin;
use App\Http\Requests\Admin\TruckModelsRequest;
use App\Models\TruckModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use App\Http\Controllers\Controller;

class TruckModelsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
//        abort_if(Gate::denies('all_suggestions'), 403);

        $truckModels = TruckModel::orderBy('created_at', 'desc')->paginate();
        return view('admin.pages.truck-models.index', compact('truckModels'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.pages.truck-models.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(TruckModelsRequest $request)
    {
        TruckModel::create($request->validated());


        return redirect()->route('admin.truck-models.index')->with('success', 'Added');
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $truckModel = TruckModel::whereId($id)->first();
        return view('admin.pages.truck-models.edit', compact('truckModel'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update( TruckModelsRequest $request, $id)
    {
        $truckModel = TruckModel::whereId($id)->first();
        $truckModel->update($request->validated());

       return redirect()->back()->with('success', 'Updated');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
//        abort_if(Gate::denies('delete_suggestions'), 403);

        $truckModel = TruckModel::whereId($id)->first();
        $truckModel->delete();
        return redirect()->route('admin.truck-models.index')->with('success', 'Deleted');

    }
}
