<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\TruckCategoriesRequest;
use App\Http\Requests\Admin\TruckTypesRequest;
use App\Models\TruckCategory;
use App\Models\TruckType;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use App\Http\Controllers\Controller;

class TruckTypesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
//        abort_if(Gate::denies('all_suggestions'), 403);

        $truckTypes = TruckType::orderBy('created_at', 'desc')->paginate();
        return view('admin.pages.truck-types.index', compact('truckTypes'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.pages.truck-types.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(TruckTypesRequest $request)
    {
        $truckType=TruckType::create($request->validated());
        if ($request->image) {
            $image= $request->file('image');
            $image_name = time() . '-' . $image->getClientOriginalName();
            $image->move(public_path() . '/images/types/', $image_name);
            $truckType->update(['image' => $image_name]);


        }


        return redirect()->route('admin.truck-types.index')->with('success', 'Added');
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $truckType = TruckType::whereId($id)->first();
        return view('admin.pages.truck-types.edit', compact('truckType'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update( TruckTypesRequest $request, $id)
    {
        $truckType = TruckType::whereId($id)->first();
        $truckType->update($request->validated());
        if ($request->image) {
            $image= $request->file('image');
            $image_name = time() . '-' . $image->getClientOriginalName();
            $image->move(public_path() . '/images/types/', $image_name);
            $truckType->update(['image' => $image_name]);


        }

       return redirect()->back()->with('success', 'Updated');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
//        abort_if(Gate::denies('delete_suggestions'), 403);

        $truckType = TruckType::whereId($id)->first();
        $truckType->delete();
        return redirect()->route('admin.truck-types.index')->with('success', 'Deleted');

    }
}
