<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\UsersRequest;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;

class UsersController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
//        abort_if(Gate::denies('all_users'), 403);
        $from=Carbon::parse($request->from)->toDateString();
        $to=Carbon::parse($request->to)->toDateString()??Carbon::now()->toDateString();

        $users=User::orderBy('created_at','desc')
            ->when($request->from && $request->to,function ($query)use($from,$to){
                $query->whereBetween('created_at',[$from,$to]);
            })
            ->when($request->search,function ($query)use($request){
                $query->where('name','like','%'.$request->search.'%');
            })
            ->when($request->id,function ($query)use($request){
                $query->where('id',$request->id);
            })

            ->paginate();
        return view('admin.pages.users.index',compact('users'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
//        abort_if(Gate::denies('edit_users'), 403);

        $user=User::whereId($id)->first();
        return view('admin.pages.users.edit',compact('user'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UsersRequest $request, $id)
    {
//        abort_if(Gate::denies('edit_users'), 403);

        $user=User::whereId($id)->first();
        $user->update($request->validated());
        if ($request->image) {
            $image = $request->file('image');
            $image_name = time() . '-' . $image->getClientOriginalName();
            $image->move(public_path() . '/images/users/', $image_name);
            $user->update(['image' => $image_name]);
        }

        if($request->password!=null){
            $user->update(['password'=>Hash::make($request->password)]);
        }

        return redirect()->route('admin.users.index')->with('success','Update');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
//        abort_if(Gate::denies('delete_users'), 403);

        $user=User::whereId($id)->first();
//        $image_path = public_path().'/assets/img/user/'.$user->getAttributes()['img'];
////        dd($user->getAttributes()['img'] );
//        if($user->getAttributes()['img'] !=null && $user->social_id==null) {
//            unlink($image_path);
//        }

        $user->delete();

        return redirect()->route('admin.users.index')->with('success','Deleted');

    }
    public function status($id)
    {

        $user=User::whereId($id)->first();
        $user->update([
            'status'=>$user->status==1?2:1
        ]);

        return redirect()->route('admin.users.index')->with('success','Deleted');

    }

}
