<?php

namespace App\Http\Controllers\Api\Drivers;

use App\Http\Controllers\Controller;
use App\Http\Requests\SuggestionsRequest;
use App\Http\Requests\TechnicalSupportRequest;
use App\Http\Resources\SuggestionsResource;
use App\Http\Resources\TechnicalSupportResource;
use App\Models\Setting;
use App\Models\TechnicalSupport;
use App\Models\Suggestion;
use Throwable;

class DriverSettingController extends Controller
{

    public function list_about_app()
    {
        try {
            $about = Setting::select('about_app')->skip(1)->first();
            return apiResponse(200, null, $about,'about_app');

        } catch (Throwable $th) {
            return apiResponse($th->getCode(), $th->getMessage(), null);
        }
    }

    public function list_terms_and_conditions()
    {
        try {
            $terms = Setting::select('terms_and_conditions')->skip(1)->first();
            return apiResponse(200, null, $terms,'terms_and_conditions');

        } catch (Throwable $th) {
            return apiResponse($th->getCode(), $th->getMessage(), null);
        }
    }

    public function list_privacy_policy()
    {
        try {
            $terms = Setting::select('privacy_policy')->skip(1)->first();
            return apiResponse(200, null, $terms,'privacy_policy');

        } catch (Throwable $th) {
            return apiResponse($th->getCode(), $th->getMessage(), null);
        }
    }

    public function technical_support(TechnicalSupportRequest $request)
    {
        try {
            $message = TechnicalSupport::create([
                'name' => $request->name,
                'email' => $request->email,
                'mobile' => $request->mobile,
                'message' => $request->message,
            ]);

            return apiResponse(200, 'message is sent to technical support', new TechnicalSupportResource($message));

        } catch (Throwable $th) {
            return apiResponse($th->getCode(), $th->getMessage(), null);
        }
    }


    public function send_suggestion(SuggestionsRequest $request)
    {
        try {
            $suggestion = Suggestion::create([
                'name' => $request->name,
                'email' => $request->email,
                'mobile' => $request->mobile,
                'message' => $request->message,
            ]);

            return apiResponse(200, 'message is sent to suggestion and complaints', new SuggestionsResource($suggestion));

        } catch (Throwable $th) {
            return apiResponse($th->getCode(), $th->getMessage(), null);
        }
    }


}
