<?php

namespace App\Http\Controllers\Api\Drivers;

use App\Http\Controllers\Controller;
use App\Http\Requests\TruckImageRequest;
use App\Http\Requests\TruckRequest;
use App\Http\Resources\TruckCategoryResource;
use App\Http\Resources\TruckHeightResource;
use App\Http\Resources\TruckLengthResource;
use App\Http\Resources\TruckLoadCapacityResource;
use App\Http\Resources\TruckModelResource;
use App\Http\Resources\TruckNumberOfAxlesResource;
use App\Http\Resources\TruckResource;
use App\Http\Resources\TruckTypeResource;
use App\Http\Resources\TruckWidthResource;
use App\Models\Truck;
use App\Models\TruckCategory;
use App\Models\TruckHeight;
use App\Models\TruckImage;
use App\Models\TruckLength;
use App\Models\TruckLoadCapacity;
use App\Models\TruckModel;
use App\Models\TruckNumberOfAxles;
use App\Models\TruckType;
use App\Models\TruckWidth;
use Throwable;

class DriverTruckController extends Controller
{

    public function list_truck_types()
    {
        try {
            $types = TruckType::get();
            return apiResponse(200, null, TruckTypeResource::collection($types));

        } catch (Throwable $th) {
            return apiResponse($th->getCode(), $th->getMessage(), null);
        }
    }


    public function list_truck_models()
    {
        try {
            $models = TruckModel::get();
            return apiResponse(200, null, TruckModelResource::collection($models));

        } catch (Throwable $th) {
            return apiResponse($th->getCode(), $th->getMessage(), null);
        }
    }


    public function list_truck_category()
    {
        try {
            $categories = TruckCategory::get();
            return apiResponse(200, null, TruckCategoryResource::collection($categories));

        } catch (Throwable $th) {
            return apiResponse($th->getCode(), $th->getMessage(), null);
        }
    }


    public function list_truck_height()
    {
        try {
            $heights = TruckHeight::get();
            return apiResponse(200, null, TruckHeightResource::collection($heights));

        } catch (Throwable $th) {
            return apiResponse($th->getCode(), $th->getMessage(), null);
        }
    }


    public function list_truck_width()
    {
        try {
            $widths = TruckWidth::get();
            return apiResponse(200, null, TruckWidthResource::collection($widths));

        } catch (Throwable $th) {
            return apiResponse($th->getCode(), $th->getMessage(), null);
        }
    }


    public function list_truck_length()
    {
        try {
            $lengths = TruckLength::get();
            return apiResponse(200, null, TruckLengthResource::collection($lengths));

        } catch (Throwable $th) {
            return apiResponse($th->getCode(), $th->getMessage(), null);
        }
    }

    public function list_truck_load_capacity()
    {
        try {
            $loads = TruckLoadCapacity::get();
            return apiResponse(200, null, TruckLoadCapacityResource::collection($loads));

        } catch (Throwable $th) {
            return apiResponse($th->getCode(), $th->getMessage(), null);
        }
    }


    public function list_truck_number_of_axles()
    {
        try {
            $axles = TruckNumberOfAxles::get();
            return apiResponse(200, null, TruckNumberOfAxlesResource::collection($axles));


        } catch (Throwable $th) {
            return apiResponse($th->getCode(), $th->getMessage(), null);
        }
    }


    public function save_truck(TruckRequest $request)
    {
        try {
            $type=TruckType::whereId($request->type_id)->first()->kilo_price;
            $category=TruckCategory::whereId($request->catrgory_id)->first()->kilo_price;
            $model=TruckModel::whereId($request->model_id)->first()->kilo_price;
            $length=TruckLength::whereId($request->length_id)->first()->kilo_price;
            $width=TruckWidth::whereId($request->width_id)->first()->kilo_price;
            $height=TruckHeight::whereId($request->height_id)->first()->kilo_price;
            $loadCapacity=TruckLoadCapacity::whereId($request->load_capacity_id)->first()->kilo_price;
            $numberOfAxels= TruckNumberOfAxles::whereId($request->number_of_axles_id)->first()->kilo_price;

            $truck = Truck::create([
                'type_id' => $request->type_id,
                'number' => $request->number,
                'catrgory_id' => $request->catrgory_id,
                'model_id' => $request->model_id,
                'color' => $request->color,
                'length_id' => $request->length_id,
                'width_id' => $request->width_id,
                'height_id' => $request->height_id,
                'load_capacity_id' => $request->load_capacity_id,
                'number_of_axles_id' => $request->number_of_axles_id,
                'driver_id' => auth('driver')->user()->id,
                'kilo_price'=>($type+$category+$model+$length+$width+$height+$loadCapacity+$numberOfAxels)

            ]);

            return apiResponse(200, 'truck is added', new TruckResource($truck));
        } catch (Throwable $th) {
            return apiResponse($th->getCode(), $th->getMessage(), null);
        }
    }

    public function upload_truck_images(TruckImageRequest $request)
    {

        try {
            if ($request->hasFile('images')) {
                foreach ($request->file('images') as $image) {

                    $file_name = Time() . '-' . $image->getClientOriginalName();
                    $file_path = public_path() . '/images';
                    $image->move($file_path, $file_name);

                    TruckImage::create([
                        'image' => $file_name,
                        'driver_id' => auth('driver')->user()->id,
                    ]);
                }
                return apiResponse(200, 'upload image is success', $file_name);
            }
            return apiResponse(404, 'image not found', null);
        } catch (Throwable $th) {
            return apiResponse($th->getCode(), $th->getMessage(), null);
        }
    }


}
