<?php

namespace App\Http\Controllers\Api\Users;

use App\Events\MyMessagesEvent;
use App\Events\SendMessageEvent;
use App\Http\Controllers\Controller;
use App\Http\Resources\DriverResource;
use App\Http\Resources\MessageResource;
use App\Http\Resources\UserResource;
use App\Services\External\Notification as PushNotificationService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Message;
use App\Models\User;
use App\Models\Driver;

class MessageController extends Controller
{

    public function messages(Request $request)
    {
        $user = auth('user')->user();
        $userId = $user->id;
        $userType = 'user';
        $chats = Message::chatsForUser($userId, $userType)
            ->select('sender_id', 'sender_type', 'receiver_id', 'receiver_type','created_at')
            ->distinct()
            ->latest()
            ->get();



        $chatPartners = [];
        foreach ($chats as $chat) {
            if ($chat->sender_id == $userId && $chat->sender_type == $userType) {
                if ($chat->receiver_type == 'user'){
                    $partner = User::find($chat->receiver_id) ;
                }else{
                    $partner = Driver::find($chat->receiver_id) ;
                }

                    $lastMessage = Message::where(function ($query) use ($userId, $userType, $chat) {
                    $query->where('sender_id', $userId)
                        ->where('sender_type', $userType)
                        ->where('receiver_id', $chat->receiver_id)
                        ->where('receiver_type', $chat->receiver_type);
                })
                    ->orWhere(function ($query) use ($userId, $userType, $chat) {
                        $query->where('receiver_id', $userId)
                            ->where('receiver_type', $userType)
                            ->where('sender_id', $chat->receiver_id)
                            ->where('sender_type', $chat->receiver_type);
                    })
                    ->latest()
                    ->first();

                $partner_object = [
                    'id' => $partner->id,
                    'name' => $partner->name,
                    'online' => $partner->online,
                    'image' => $chat->receiver_type == 'user' ?  $partner->image : $partner->profile_image,
                ];

                $chatPartners[] = [
                    'partner_id' => $chat->receiver_id,
                    'partner_type' => $chat->receiver_type,
                    'partner_object' => $partner_object,
                    'last_message' => $lastMessage ? new MessageResource($lastMessage) : null,

                ];
            }
            else {

                if ($chat->sender_type == 'user'){
                    $partner =  User::find($chat->sender_id);
                }else{
                    $partner = Driver::find($chat->sender_id) ;
                }


                $lastMessage = Message::where(function ($query) use ($userId, $userType, $chat) {
                    $query->where('sender_id', $userId)
                        ->where('sender_type', $userType)
                        ->where('receiver_id', $chat->sender_id)
                        ->where('receiver_type', $chat->sender_type);
                })
                    ->orWhere(function ($query) use ($userId, $userType, $chat) {
                        $query->where('receiver_id', $userId)
                            ->where('receiver_type', $userType)
                            ->where('sender_id', $chat->sender_id)
                            ->where('sender_type', $chat->sender_type);
                    })
                    ->latest()
                    ->first();


                $partner_object = [
                    'id' => $partner->id,
                    'name' => $partner->name,
                    'online' => $partner->online,
                    'image' => $chat->sender_type == 'user' ?  $partner->image : $partner->profile_image,
                ];


                $chatPartners[] = [
                    'partner_id' => $chat->sender_id,
                    'partner_type' => $chat->sender_type,
                    'partner_object' => $partner_object,
                    'last_message' => $lastMessage ? new MessageResource($lastMessage) : null,

                ];
            }
        }

        $uniquePartners = array_map("unserialize", array_unique(array_map("serialize", $chatPartners)));


        return apiResponse(200, 'chats', array_values($uniquePartners));

//        return response()->json($chatPartners);
    }

    public function driver_messages(Request $request)
    {

        $driver = auth('driver')->user();
        $driverId = $driver->id;
//        $driverType = 'driver';

        $chats = Message::chatsForUser($driverId, 'driver')
            ->select('sender_id', 'sender_type', 'receiver_id', 'receiver_type','created_at')
            ->distinct()
            ->orderBy('created_at','desc')

            ->get();

//        dd($chats);

        $chatPartners = [];
        foreach ($chats as $chat) {
            if ($chat->sender_id == $driverId && $chat->sender_type == 'driver') {

                $partner = User::find($chat->receiver_id);

                $lastMessage = Message::where(function ($query) use ($driverId, $chat) {
                    $query->where('sender_id', $driverId)
                        ->where('sender_type', 'driver')
                        ->where('receiver_id', $chat->sender_id)
                        ->where('receiver_type', $chat->sender_type);
                })
                    ->orWhere(function ($query) use ($driverId, $chat) {
                        $query->where('receiver_id', $driverId)
                            ->where('receiver_type', 'driver')
                            ->where('sender_id', $chat->sender_id)
                            ->where('sender_type', $chat->sender_type);
                    })
                    ->latest()
                    ->first();

                $chatPartners[] = [
                    'partner_id' => $chat->receiver_id,
                    'partner_type' => $chat->receiver_type,
                    'partner_object' => new UserResource($partner),
                    'last_message' => $lastMessage ? new MessageResource($lastMessage) : null,

                ];
            }
            else {

                $partner = User::find($chat->sender_id);


                $lastMessage = Message::where(function ($query) use ($driverId, $chat) {
                    $query->where('sender_id', $driverId)
                        ->where('sender_type', 'driver')
                        ->where('receiver_id', $chat->sender_id)
                        ->where('receiver_type', $chat->sender_type);
                })
                    ->orWhere(function ($query) use ($driverId, $chat) {
                        $query->where('receiver_id', $driverId)
                            ->where('receiver_type', 'driver')
                            ->where('sender_id', $chat->sender_id)
                            ->where('sender_type', $chat->sender_type);
                    })
                    ->latest()
                    ->first();

                $chatPartners[] = [
                    'partner_id' => $chat->sender_id,
                    'partner_type' => $chat->sender_type,
                    'partner_object' => new UserResource($partner),
                    'last_message' => $lastMessage ? new MessageResource($lastMessage) : null,


                ];
            }
        }


        $indexedPartners = [];
        foreach ($chatPartners as $partner) {
            $partnerId = $partner['partner_id'];
            if (!isset($indexedPartners[$partnerId]) || ($partner['last_message'] !== null && $indexedPartners[$partnerId]['last_message'] === null)) {
                $indexedPartners[$partnerId] = $partner;
            }
        }


// Get unique partners using array_values to reset keys
        $uniquePartners = array_values($indexedPartners);

        return apiResponse(200, 'chats', $uniquePartners);
    }


    public function chat_messages(Request $request)
    {

        $messages = Message::betweenPartners(auth('user')->id(), 'user', $request->partner_id, $request->partner_type)
            ->get();
        return apiResponse(200, 'messages', MessageResource::collection($messages));
    }

    public function driver_chat_messages(Request $request)
    {
        $messages = Message::betweenPartners(auth('driver')->id(), 'driver', $request->user_id, 'user')->get();
        return apiResponse(200, 'messages', MessageResource::collection($messages));
    }


    public function send_message(Request $request)
    {

        $request->validate([
            'receiver_type' => 'required|string|in:user,driver',
            'receiver_id' => $request->receiver_type == 'user' ? 'required|integer|exists:users,id' : 'required|integer|exists:drivers,id' ,
            'message' => 'nullable|string|max:255',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg',
        ]);


        if ($request->hasFile('image')) {
            $image = $request->file('image');
            $imageName = Time() . '-' . $image->getClientOriginalName();
            $path = public_path() . '/images';
            $image->move($path, $imageName);
        }

        $user = auth('user')->user();
//        $user->messages()->attach($request->driver_id, ['type' => $request->type,'message' => $request->message, 'image' => $imageName ?? null , 'shipment_id' => $request->shipment_id ]);
//        $messages = DB::table('messages')->where('user_id', $user->id)->where('driver_id', $request->driver_id)->orderBy('created_at' , 'desc')->get();



        $message = Message::create([
            'sender_id' => $user->id,
            'sender_type' => 'user',
            'receiver_id' => $request->receiver_id,
            'receiver_type' => $request->receiver_type,
            'message' => $request->message,
            'image' => $imageName ?? null
        ]);
        $messages = Message::betweenPartners($user->id, 'user', $request->receiver_id, $request->receiver_type)->get();

//        $messages = DB::table('messages')->where('user_id', $user->id)->where('driver_id', $request->driver_id)->orderBy('created_at' , 'desc')->get();


        $user_type =  $message->receiver_type == 'user' ? 'users' : 'drivers';
        PushNotificationService::notify($user_type, 'message', [$message->receiver_id], null, 'Qwater', $message->message ? $message->message : $message->image, 'Qwater', new MessageResource($message));


//        broadcast(new SendMessageEvent($messages[0]));
//        broadcast(new MyMessagesEvent($messages,auth()->user()->id));
//        broadcast(new MyMessagesEvent($messages,$request->user_id));

        return apiResponse(200, 'message is sent', MessageResource::collection($messages));
    }


    public function driver_send_message(Request $request)
    {

        $request->validate([
            'user_id' =>'required|integer|exists:users,id' ,
            'message' => 'nullable|string|max:255',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg',
        ]);


        if ($request->hasFile('image')) {

            $image = $request->file('image');
            $imageName = Time() . '-' . $image->getClientOriginalName();
            $path = public_path() . '/images';
            $image->move($path, $imageName);
        }

        $driver = auth('driver')->user();
//        $driver->messages()->attach($request->user_id, ['message' => $request->message, 'image' => $imageName ?? null]);
//        $messages = DB::table('messages')->where('driver_id', $driver->id)->where('user_id', $request->user_id)->get();


        $message = Message::create([
            'sender_id' => $driver->id,
            'sender_type' => 'driver',
            'receiver_id' => $request->user_id,
            'receiver_type' => 'user',
            'message' => $request->message,
            'image' => $imageName ?? null
        ]);
        $messages = Message::betweenPartners($driver->id, 'driver', $request->user_id, 'user')->get();


        PushNotificationService::notify('users', 'message', [$message->receiver_id], null, 'Qwater', $message->message ? $message->message : $message->image, 'Qwater', new MessageResource($message));


        return apiResponse(200, 'message is sent', MessageResource::collection($messages));
    }


}
