<?php

namespace App\Http\Controllers\Api\Users;

use App\Http\Controllers\Controller;
use App\Http\Resources\NotificationResource;
use App\Models\Notification;
use Illuminate\Http\Request;

class NotificationController extends Controller
{
    public function notifications()
    {
        $user = auth('user')->user();
        $notifications = Notification::select('id', 'title_' . app()->getLocale(), 'body_' . app()->getLocale(), 'user_id', 'created_at')->where('user_id', $user->id)
            ->orWhere('user_id', 0)
            ->orderBy('created_at', 'desc')
            ->get();

        foreach ($notifications as $notification) {
            $notification->added_at = date('d-m-Y h:i A', strtotime($notification->created_at));
        }

        return apiResponse(200, null, $notifications);
    }


    public function driver_notifications()
    {
        $driver = auth('driver')->user();
        $notifications = Notification::select('id', 'title_' . app()->getLocale(), 'body_' . app()->getLocale(), 'driver_id', 'created_at')->where('driver_id', $driver->id)
            ->orWhere('driver_id', 0)
            ->orderBy('created_at', 'desc')
            ->get();

        foreach ($notifications as $notification) {
            $notification->added_at = date('d-m-Y h:i A', strtotime($notification->created_at));
        }

        return apiResponse(200, null, $notifications);
    }
}
