<?php

namespace App\Http\Controllers\Api\Users;

use App\Http\Controllers\Controller;
use App\Http\Requests\SuggestionsRequest;
use App\Http\Requests\TechnicalSupportRequest;
use App\Http\Resources\InsuranceDetailsResource;
use App\Http\Resources\SuggestionsResource;
use App\Http\Resources\TechnicalSupportResource;
use App\Models\HowShipment;
use App\Models\InsuranceDetail;
use App\Models\Setting;
use App\Models\Slider;
use App\Models\Suggestion;
use App\Models\TechnicalSupport;
use Illuminate\Http\Request;

class SettingController extends Controller
{
    public function list_about_app()
    {
        try {
            $about = Setting::select('about_app')->first();
            return apiResponse(200 , null , $about,'about_app');

        } catch (\Throwable $th) {
            return apiResponse($th->getCode(), $th->getMessage() , null);
        }
    }

    public function list_terms_and_conditions()
    {
        try {
            $terms = Setting::select('terms_and_conditions')->first();
            return apiResponse(200 , null , $terms,'terms_and_conditions');

        } catch (\Throwable $th) {
            return apiResponse($th->getCode(), $th->getMessage() , null);
        }
    }

    public function list_privacy_policy()
    {
        try {
            $terms = Setting::select('privacy_policy')->first();
            return apiResponse(200 , null , $terms,'privacy_policy');

        } catch (\Throwable $th) {
            return apiResponse($th->getCode(), $th->getMessage() , null);
        }
    }

    public function technical_support(TechnicalSupportRequest $request)
    {
        try {
            $message = TechnicalSupport::create([
                'name' => $request->name,
                'email' => $request->email,
                'mobile' => $request->mobile,
                'message' => $request->message,
            ]);

            return apiResponse(200 ,'message is sent to technical support', new TechnicalSupportResource($message));

        } catch (\Throwable $th) {
            return apiResponse($th->getCode(), $th->getMessage() , null);
        }
    }

    public function send_suggestion(SuggestionsRequest $request)
    {
        try {
            $suggestion = Suggestion::create([
                'name' => $request->name,
                'email' => $request->email,
                'mobile' => $request->mobile,
                'message' => $request->message,
            ]);

            return apiResponse(200 , 'message is sent to suggestion and complaints' , new SuggestionsResource($suggestion));

        } catch (\Throwable $th) {
            return apiResponse($th->getCode(), $th->getMessage() , null);
        }
    }

    public function insurance_details ()
    {
        try {
            $insurance = InsuranceDetail::first();
            return apiResponse(200, null, new InsuranceDetailsResource($insurance));

        } catch (\Throwable $th) {
            return apiResponse($th->getCode(), $th->getMessage() , null);
        }
    }

    public function how_shipment ()
    {

        try {
            $how_shipment = HowShipment::select('id' , 'text')->get();
            return apiResponse(200, null,$how_shipment);

        } catch (\Throwable $th) {
            return apiResponse($th->getCode(), $th->getMessage() , null);
        }
    }
    public function sliders ()
    {
        try {
            $sliders = Slider::get();
            return apiResponse(200, null,$sliders);

        } catch (\Throwable $th) {
            return apiResponse($th->getCode(), $th->getMessage() , null);
        }
    }




}
