<?php

namespace App\Http\Controllers\Api\Users;

use App\Http\Controllers\Controller;
use App\Http\Requests\ResetPasswordRequest;
use App\Http\Resources\CountryResource;
use App\Http\Resources\UserResource;
use App\Models\Country;
use App\Models\ForgetPassword;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\PHPMailer;
use Pusher\PushNotifications\PushNotifications;

class UserAuthController extends Controller
{
    public function register(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'password' => 'required|same:password_confirmation',
            'mobile' => 'required|unique:users,mobile',
            'country_id' => 'required|exists:countries,id',
        ]);

        if ($validator->fails()) {
            return apiResponse(401, $validator->errors()->first(), null);
        }

        $user = User::create([
            'password' => Hash::make($request->password),
            'mobile' => $request->mobile,
            'country_id' => $request->country_id,
            'verification_code' => 2222,
        ]);

        $token = Auth::login($user);
        $user = new UserResource(auth()->user());
        $user['token'] = $token;

        return apiResponse(200, 'register is success', [
            'token' => $token,
            'user' => new UserResource(auth('user')->user()),
        ]);

    }

    public function verifyCode(Request $request)
    {

        try {
            if ($request->code) {
                $user = auth('user')->user();
                if ($user->verification_code == $request->code) {

                    return apiResponse(200, 'code is valid', null);
                }
                return apiResponse(404, 'code is invalid', null);
            }

        } catch (\Throwable $th) {
            return apiResponse(404, $th->getMessage(), null);
        }
    }

    public function update_user(Request $request)
    {
        try {
            $user = auth()->user();

            $user->update([
                'name' => $request->name,
                'email' => $request->email,
            ]);

            if ($request->hasFile('image')) {

                $image = $request->file('image');
                $image_name = Time() . '-' . $image->getClientOriginalName();
                $file_path = public_path() . '/images';
                $image->move($file_path, $image_name);

                $user->image = $image_name;
                $user->save();

            }

            if ($request->hasFile('front_id_image') && $request->hasFile('back_id_image')) {

                $front_id_image = $request->file('front_id_image');
                $front_id_image_name = Time() . '-' . $front_id_image->getClientOriginalName();
                $file_path = public_path() . '/images';
                $front_id_image->move($file_path, $front_id_image_name);

                $back_id_image = $request->file('back_id_image');
                $back_id_image_name = Time() . '-' . $back_id_image->getClientOriginalName();
                $file_path = public_path() . '/images';
                $back_id_image->move($file_path, $back_id_image_name);

                $user->front_id_image = $front_id_image_name;
                $user->back_id_image = $back_id_image_name;
                $user->save();
            }

            $token = Auth::login($user);
            $user->token = $token;

            //  $user=User::where('email',$request->email)->first();

            return apiResponse(200, 'profile is updated', [
                'token' => $token,
                'user' => new UserResource(auth('user')->user()),
            ]);

        } catch (\Throwable $th) {
            return apiResponse(404, $th->getMessage(), null);
        }
    }

    public function login()
    {
        try {
            $credentials = request(['mobile', 'password']);

            if (!$token = auth('user')->attempt($credentials)) {
                return apiResponse(401, 'email or password are invalid', null);
            }

            return apiResponse(200, 'login is success', [
                'token' => $token,
                'user' => new UserResource(auth('user')->user()),
            ]);

        } catch (\Throwable $th) {
            return apiResponse(404, $th->getMessage(), null);
        }
    }

    public function logout()
    {
        auth('user')->logout();
        return response()->json(['message' => 'Successfully logged out']);
    }

    protected function respondWithToken($token)
    {
        return response()->json([
            'access_token' => $token,
            'token_type' => 'bearer',
            'expires_in' => auth()->factory()->getTTL() * 60,
        ]);
    }

    public function forgetPassword(Request $request)
    {
        try {
            $user = User::where('mobile', $request->mobile)->first();
            if ($user) {

                // $code = rand(1111,9999);
                $code = 1111;
                $user->forget_code = $code;
                $user->save();
                $token = Auth::login($user);
                $user['token'] = $token;

                // send code to user at mobile
                return apiResponse(200, 'code is sent', $user);
            }
            return apiResponse(404, 'user not found', null);

        } catch (\Throwable $th) {
            return apiResponse(404, $th->getMessage(), null);
        }
    }

    public function check_forget_Code(Request $request)
    {
        try {
            if ($request->code) {
                $user = User::where('forget_code', $request->code)->first();

                if ($user) {

                    return apiResponse(200, 'code is valid', null);
                }

                return apiResponse(404, 'code is invalid', null);
            }

        } catch (\Throwable $th) {
            return apiResponse(404, $th->getMessage(), null);
        }
    }

    public function resetPassword(ResetPasswordRequest $request)
    {
        try {
            $user = User::where('forget_code', $request->code)->first();

            if ($user) {
                $user->update([
                    'password' => Hash::make($request->new_password),
                ]);

                return apiResponse(200, 'password is updated', null);
            } else {
                return apiResponse(404, 'code is not valid', null);
            }

        } catch (\Throwable $th) {
            return apiResponse(404, $th->getMessage(), null);
        }
    }

    public function send_email(Request $request)
    {

        $to = $request->email;

        $mail = new PHPMailer(true);

        try {

            //Server settings
            $mail->isSMTP();
            $mail->Host = 'smtp.gmail.com'; // Specify main and backup SMTP servers
            $mail->SMTPAuth = true; // Enable SMTP authentication
            $mail->Username = 'msarat2425@gmail.com'; // SMTP username
            $mail->Password = 'orwa dowy pkqd jude'; // SMTP password
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS; // Enable TLS encryption, `ssl` also accepted
            $mail->Port = 587; // TCP port to connect to

            $mail->SMTPOptions = array(
                'ssl' => array(
                    'verify_peer' => false,
                    'verify_peer_name' => false,
                    'allow_self_signed' => false,

                ),
            );

            //Recipients
            $mail->setFrom('msarat2425@gmail.com', 'MSARAT World');
            $mail->addAddress($to, 'Recipient Name'); // Add a recipient

            // Content
            $mail->isHTML(true); // Set email format to HTML
            $mail->Subject = 'Subject of the email';
            $mail->Body = 'This is the HTML message body <b>in bold!</b>';
            $mail->AltBody = 'This is the plain text version of the email content';

            $mail->send();

        } catch (Exception $e) {
            echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
        }

        //   $data = array('name'=>$request->message);

        //   Mail::send(['text'=>'mail'], $data, function($message) use ($to) {

        //      $message->to($to, 'Tutorials Point')->subject
        //         ('VONNN APP');

        //         $message->from('hello@vonnn.com','VONNN APP');

        //   });

        return "Successfully sent the email";

    }

    public function list_countries()
    {

        //     $to="atef7374@gmail.com";
        //     $from="atef7374@gmail.com";

        //   $data = array('name'=>"VONNN APP");

        //   Mail::send(['text'=>'mail'], $data, function($message) {
        //      $message->to("atef737475@gmail.com", 'Tutorials Point')->subject
        //         ('Laravel Basic Testing Mail');

        //   });

        //     return "Successfully sent the email";

        try {
            $countries = Country::get();
            return apiResponse(200, null, CountryResource::collection($countries));

        } catch (\Throwable $th) {
            return apiResponse(404, $th->getMessage(), null);
        }
    }

    public function generateAuthToken(Request $request)
    {
        $beamsClient = new PushNotifications(array(
            "instanceId" => config('services.Beams.Beams_Instance_Id'),
            "secretKey" => config('services.Beams.Beams_Secret_key'),
        ));
        $beamsToken = $beamsClient->generateToken("users-" . auth('user')->user()->id);
        return response()->json($beamsToken);

    }

    public function onlineStatus($status)
    {

        $user = auth()->user();
        if (!$user) {
            return apiResponse(404, 'user not found', null);
        }

        $user->update([
            'online' => $status,
        ]);

        return apiResponse(200, 'Status is updated', null);
    }

    public function delete($id){
        $user = User::find($id);
        if ($user){
            $user->delete();

            return apiResponse(200, 'User deleted successfully', null);
        }

        return apiResponse(404, 'User not found', null);
    }
}
