<?php

namespace App\Http\Controllers\Api\Users;

use App\Http\Controllers\Controller;
use App\Http\Requests\AddressRequest;
use App\Http\Requests\ChangePasswordRequest;
use App\Http\Requests\RateRequest;
use App\Http\Requests\UserRequest;
use App\Http\Resources\AddressResource;
use App\Http\Resources\MyAddressResource;
use App\Http\Resources\RateResource;
use App\Http\Resources\WalletResource;
use App\Http\Resources\UserResource;
use App\Models\UserAdress;
use App\Models\User;
use App\Models\FromAddress;
use App\Models\Country;
use App\Models\ShipmentCity;
use App\Models\ShipmentGovernorate;
use App\Models\FromAddressDetail;
use App\Models\ToAddress;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class UserController extends Controller
{
    public function change_password(Request $request)
    {

        $user = auth('user')->user();

        if (Hash::check($request->old_password, $user->password)) {

            if($request->password == $request->password_confirmation){

        if($request->password != $request->old_password){
           $user->update([ 'password' => Hash::make($request->password)]);
           return apiResponse(200 ,'password is updated' , null);
        }
          else {
            return apiResponse(401, 'The Password And Old Password Must Be Different' , null);
        }
        } else {
            return apiResponse(401, 'The Password And Password Confirmation Does Not Match' , null);
        }
        } else {
            return apiResponse(401, 'Old Password Is Invalid' , null);
        }
    }


    public function saveLocation(Request $request)
    {
        try {
             if($request->has(['longitude','latitude'])){
                $user = auth('user')->user();
                $address = UserAdress::create([
                  'user_id'   =>   $user->id,
                  'longitude' =>   $request->longitude,
                  'latitude'  =>   $request->latitude,
                ]);


            return apiResponse(200 , 'location is saved' , new AddressResource($address));
            }
            return apiResponse(404 , 'location not found' , null);

          } catch (\Throwable $th) {
            return apiResponse(404, $th->getMessage() , null);
          }
    }


    public function my_addresses(Request $request)
    {
          $user = auth('user')->user();

          $my_addresses = FromAddress::select('id','latitude','longitude')->where('user_id',$user->id)->orderBy('id','desc')->get();

          foreach($my_addresses as $address){


            $address_details =  FromAddressDetail::where('from_address_id',$address->id)->first();


            if( $address_details){
            $address['address_name'] = $address_details->address_name;
            $address['street_name'] = $address_details->street_name;
            $address['description'] = $address_details->description;
            $address['country'] = Country::select('id','name_'.$request->header('language'),'flag')->where('id',$address_details->country_id)->first();
            $address['city'] = ShipmentCity::select('id','name_'.$request->header('language'))->where('id',$address_details->city_id)->first();
            $address['governorate'] = ShipmentGovernorate::select('id','name_'.$request->header('language'))->where('id',$address_details->governorate_id)->first();


            }else {
                  $address->address_name = "";
                  $address->street_name = "";
                  $address->description  = "";
            }



          }

          return apiResponse(200 , null , $my_addresses);
    }


    public function my_address_details()
    {
         return AddressResource::collection(auth('user')->user()->addresses);

//        $user = auth('user')->user();
//          $my_addresses_details = FromAddressDetail::select('id','country_id','governorate_id','city_id','address_name','street_name','from_address_id')->where('user_id',$user->id)->get();
//
//          return apiResponse(200 , null , AddressDetailResource::collection($my_addresses_details));
    }

    public function add_address(AddressRequest $request)
    {
        try {

        $user = auth('user')->user();

        $from_address = FromAddress::create([
            'user_id' => $user->id,
            'longitude' => $request->longitude,
            'latitude'=> $request->latitude,
        ]);

          $from_address_detail = FromAddressDetail::create([
            'country_id' => $request->from_country_id ,
            'governorate_id' => $request->from_governorate_id ,
            'city_id' => $request->from_city_id ,
            'address_name'  => $request->from_address_name,
            'street_name' => $request->from_street_name ,
            'description' => $request->from_description,
            'from_address_id' => $from_address->id,
        ]);


        return apiResponse(200 , 'address is added' , $from_address_detail);
      } catch (\Throwable $th) {
        return apiResponse(404, $th->getMessage() , null);
      }
    }


    public function delete_address($address)
    {

        try {
            FromAddress::findOrFail($address)->delete();
            FromAddressDetail::where('from_address_id' , $address)->delete();

            return apiResponse(200 , 'address is removed' , null);

          } catch (\Throwable $th) {
            return apiResponse(404, $th->getMessage() , null);
          }
    }

    public function update_profile(UserRequest $request)
    {
        try {
            $user = auth('user')->user();

            if($request->hasFile('front_id_image') && $request->hasFile('back_id_image')){

                $front_id_image = $request->file('front_id_image');
                $front_id_image_name = Time().'-'.$front_id_image->getClientOriginalName();
                $file_path = public_path().'/images';
                $front_id_image->move($file_path,$front_id_image_name);

                $back_id_image = $request->file('back_id_image');
                $back_id_image_name = Time().'-'.$back_id_image->getClientOriginalName();
                $file_path = public_path().'/images';
                $back_id_image->move($file_path,$back_id_image_name);
            }

            $user->update([
                'name' => $request->name,
                'email' => $request->email,
                'mobile'=> $request->mobile,
                'front_id_image'=> $front_id_image_name,
                'back_id_image'=> $back_id_image_name,
            ]);

            return apiResponse(200 , 'profile is updated' , $user);
          } catch (\Throwable $th) {
            return apiResponse(404, $th->getMessage() , null);
          }
    }

    public function my_rates()
    {
             $user = auth('user')->user();

            $rates = $user->driver_rates;

            return apiResponse(200 , null , RateResource::collection($rates));
    }

    public function wallet()
    {
     $wallet = User::select('wallet')->where('id',auth('user')->user()->id)->first();

            return apiResponse(200 , null , new WalletResource($wallet));

    }


    public function add_rate(RateRequest $request)
    {
        try {
            $user = auth('user')->user();
            $user->driver_rates()->attach($request->driver_id,['rate' => $request->rate]);

            return apiResponse(200 , 'rate is success' , RateResource::collection($user->driver_rates));

          } catch (\Throwable $th) {
            return apiResponse(404, $th->getMessage() , null);
          }
    }




}
