<?php

namespace App\Http\Controllers\Shipper;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\LoginRequest;
use App\Models\Driver;
use App\Models\Shipment;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;
use Throwable;

class AdminLoginController extends Controller
{
    public function login()
    {
        return view('shipper.login.login');
    }

    public function submit_login(LoginRequest $request)
    {
        $remember_me = $request->has('remember_me') ? true : false;

        if (auth()->guard('shipper')->attempt(['email' => $request->email, 'password' => $request->password], $remember_me)) {
            return redirect()->route('shipper.dashboard');
        }
        return redirect()->back();
    }

    public function dashboard()
    {
//        try {
        //' 0=> waiting,1 => packing_in_progress','2 => Packed','3 => in_delivery',' 4 => deliveried'

//                $permissions = [
//
//                    'access_trucks',
//                    'create_trucks',
//                    'edit_trucks',
//                    'delete_trucks',
//
//                    'access_shipments',
//                    'edit_shipments',
//                    'delete_shipments',
//
//
//                    'access_drivers',
//                    'create_drivers',
//                    'edit_drivers',
//                    'delete_drivers',
//        ];
//
//
//        $role = Role::where([
//            'name' => 'Super Shipper',
//            'guard_name' => 'shipper'
//        ])->first();
//        $role->givePermissionTo($permissions);

        $shipments = Shipment::
            whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->count();
        $pendingShipments = Shipment::
        whereHas('drivers', function ($query) {
            $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
        })
        ->where('status', 0)

            ->count();
        $packingShipments = Shipment::
        whereHas('drivers', function ($query) {
            $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
        })
        ->where('status', 1)->count();
        $packedShipments = Shipment::where('status', 2)
               ->whereHas('drivers', function ($query) {
                   $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
               })
            ->count();
        $deliveringShipments = Shipment::where('status', 3)
            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->count();
        $deliveredShipments = Shipment::where('status', 4)

            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->count();
        $totalCost = Shipment::whereHas('drivers', function ($query) {
            $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
        })->sum('driver_price');

        $pendingShipments11 = Shipment::where('status', 0)

            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(11)->month)->count();
        $packingShipments11 = Shipment::where('status', 1)
            ->whereHas('drivers', function ($query) {
            $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
        })
            ->whereMonth('created_at', Carbon::now()->subMonths(11)->month)->count();
        $packedShipments11 = Shipment::where('status', 2)
            ->whereHas('drivers', function ($query) {
            $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
        })
            ->whereMonth('created_at', Carbon::now()->subMonths(11)->month)->count();
        $deliveringShipments11 = Shipment::where('status', 3)
            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(11)->month)->count();
        $deliveredShipments11 = Shipment::where('status', 4)
            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(11)->month)->count();

        $pendingShipments10 = Shipment::where('status', 0)
            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(10)->month)->count();
        $packingShipments10 = Shipment::where('status', 1)
            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(10)->month)->count();
        $packedShipments10 = Shipment::where('status', 2)
            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(10)->month)->count();
        $deliveringShipments10 = Shipment::where('status', 3)

            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(10)->month)->count();
        $deliveredShipments10 = Shipment::where('status', 4)
            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(10)->month)->count();

        $pendingShipments9 = Shipment::where('status', 0)
            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(9)->month)->count();
        $packingShipments9 = Shipment::where('status', 1)

            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(9)->month)->count();
        $packedShipments9 = Shipment::where('status', 2)

            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(9)->month)->count();
        $deliveringShipments9 = Shipment::where('status', 3)

            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(9)->month)->count();
        $deliveredShipments9 = Shipment::where('status', 4)

            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(9)->month)->count();

        $pendingShipments8 = Shipment::where('status', 0)

            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(8)->month)->count();
        $packingShipments8 = Shipment::where('status', 1)

            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(8)->month)->count();
        $packedShipments8 = Shipment::where('status', 2)

            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(8)->month)->count();
        $deliveringShipments8 = Shipment::where('status', 3)

            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(8)->month)->count();
        $deliveredShipments8 = Shipment::where('status', 4)

            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(8)->month)->count();

        $pendingShipments7 = Shipment::where('status', 0)
            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })


            ->whereMonth('created_at', Carbon::now()->subMonths(7)->month)->count();
        $packingShipments7 = Shipment::where('status', 1)

            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(7)->month)->count();
        $packedShipments7 = Shipment::where('status', 2)

            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(7)->month)->count();
        $deliveringShipments7 = Shipment::where('status', 3)

            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(7)->month)->count();
        $deliveredShipments7 = Shipment::where('status', 4)
            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(7)->month)->count();

        $pendingShipments6 = Shipment::where('status', 0)
            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(6)->month)->count();
        $packingShipments6 = Shipment::where('status', 1)
            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(6)->month)->count();
        $packedShipments6 = Shipment::where('status', 2)

            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(6)->month)->count();
        $deliveringShipments6 = Shipment::where('status', 3)
            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(6)->month)->count();
        $deliveredShipments6 = Shipment::where('status', 4)
            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(6)->month)->count();

        $pendingShipments5 = Shipment::where('status', 0)
            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(5)->month)->count();
        $packingShipments5 = Shipment::where('status', 1)
            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(5)->month)->count();
        $packedShipments5 = Shipment::where('status', 2)
            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(5)->month)->count();
        $deliveringShipments5 = Shipment::where('status', 3)

            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(5)->month)->count();
        $deliveredShipments5 = Shipment::where('status', 4)
            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(5)->month)->count();

        $pendingShipments4 = Shipment::where('status', 0)
            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(4)->month)->count();
        $packingShipments4 = Shipment::where('status', 1)
            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(4)->month)->count();
        $packedShipments4 = Shipment::where('status', 2)
            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(4)->month)->count();
        $deliveringShipments4 = Shipment::where('status', 3)
            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(4)->month)->count();
        $deliveredShipments4 = Shipment::where('status', 4)

            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(4)->month)->count();

        $pendingShipments3 = Shipment::where('status', 0)
            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(3)->month)->count();
        $packingShipments3 = Shipment::where('status', 1)

            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(3)->month)->count();
        $packedShipments3 = Shipment::where('status', 2)

            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(3)->month)->count();
        $deliveringShipments3 = Shipment::where('status', 3)

            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(3)->month)->count();
        $deliveredShipments3 = Shipment::where('status', 4)

            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(3)->month)->count();

        $pendingShipments2 = Shipment::where('status', 0)
            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(2)->month)->count();
        $packingShipments2 = Shipment::where('status', 1)
            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(2)->month)->count();
        $packedShipments2 = Shipment::where('status', 2)
            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(2)->month)->count();
        $deliveringShipments2 = Shipment::where('status', 3)
            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(2)->month)->count();
        $deliveredShipments2 = Shipment::where('status', 4)
            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(2)->month)->count();

        $pendingShipments1 = Shipment::where('status', 0)
            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(1)->month)->count();
        $packingShipments1 = Shipment::where('status', 1)
            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(1)->month)->count();
        $packedShipments1 = Shipment::where('status', 2)
            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(1)->month)->count();
        $deliveringShipments1 = Shipment::where('status', 3)
            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(1)->month)->count();
        $deliveredShipments1 = Shipment::where('status', 4)
            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereMonth('created_at', Carbon::now()->subMonths(1)->month)->count();
        $latestShipments = Shipment::orderBy('created_at', 'desc')
            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })

            ->whereHas('drivers', function ($query) {
            $query->where('shipment_drivers.status', 1);
             })
            ->take(10)->get();

        $latestDrivers = Driver::orderBy('created_at', 'desc')
            ->where('shipper_id',auth()->guard('shipper')->id())
            ->take(10)->get();


        return view('shipper.pages.index', compact('shipments', 'pendingShipments', 'packingShipments', 'packedShipments',
            'deliveredShipments', 'deliveringShipments', 'totalCost',
            'pendingShipments1', 'pendingShipments2', 'pendingShipments3', 'pendingShipments4', 'pendingShipments5', 'pendingShipments6',
            'pendingShipments7', 'pendingShipments8', 'pendingShipments9', 'pendingShipments10', 'pendingShipments11', 'packingShipments1', 'packingShipments2'
            , 'packingShipments3', 'packingShipments4', 'packingShipments5', 'packingShipments6', 'packingShipments7', 'packingShipments8', 'packingShipments9'
            , 'packingShipments10', 'packingShipments11', 'packedShipments1', 'packedShipments2', 'packedShipments3', 'packedShipments4', 'packedShipments5'
            , 'packedShipments6', 'packedShipments7', 'packedShipments8', 'packedShipments9', 'packedShipments10', 'packedShipments11', 'deliveringShipments1'
            , 'deliveringShipments2', 'deliveringShipments3', 'deliveringShipments4', 'deliveringShipments5', 'deliveringShipments6', 'deliveringShipments7'
            , 'deliveringShipments8', 'deliveringShipments9', 'deliveringShipments10', 'deliveringShipments11', 'deliveredShipments1', 'deliveredShipments2'
            , 'deliveredShipments3', 'deliveredShipments4', 'deliveredShipments5', 'deliveredShipments6', 'deliveredShipments7', 'deliveredShipments8'
            , 'deliveredShipments9', 'deliveredShipments10', 'deliveredShipments11', 'latestShipments','latestDrivers'

        ));

//        } catch (Throwable $th) {
//            return redirect()->back()->with(['error' => 'Dashboard Is Failed']);
//        }
    }

    public function logout()
    {
        try {
            Auth::logout();
            return redirect()->route('admin.login')->with(['success' => 'You Are Loged Out']);

        } catch (Throwable $th) {
            return redirect()->back()->with(['error' => 'Log Out Is Failed']);
        }
    }

    public function createPermissions()
    {

        $permissions = [
            'access_statistics',
            'access_about_app',
            'edit_about_app',

            'access_terms_and_conditions',
            'edit_terms_and_conditions',

            'access_privacy_policy',
            'edit_privacy_policy',

            'access_suggestions',
            'edit_suggestions',

            'access_technical_support',
            'delete_technical_support',

            'access_countries',
            'create_countries',
            'edit_countries',
            'delete_countries',

            'access_shipments_countries',
            'create_shipments_countries',
            'edit_shipments_countries',
            'delete_shipments_countries',

            'access_shipments_governorates',
            'create_shipments_governorates',
            'edit_shipments_governorates',
            'delete_shipments_governorates',

            'access_shipments_cities',
            'create_shipments_cities',
            'edit_shipments_cities',
            'delete_shipments_cities',

            'access_users',
            'edit_users',
            'delete_users',
            'update_status_users',
            'access_shipments_users',

            'access_forbidden_items',
            'create_forbidden_items',
            'edit_forbidden_items',
            'delete_forbidden_items',


            'access_truck_categories',
            'create_truck_categories',
            'edit_truck_categories',
            'delete_truck_categories',

            'access_truck_types',
            'create_truck_types',
            'edit_truck_types',
            'delete_truck_types',

            'access_truck_models',
            'create_truck_models',
            'edit_truck_models',
            'delete_truck_models',

            'access_truck_heights',
            'create_truck_heights',
            'edit_truck_heights',
            'delete_truck_heights',

            'access_truck_widths',
            'create_truck_widths',
            'edit_truck_widths',
            'delete_truck_widths',

            'access_truck_lengths',
            'create_truck_lengths',
            'edit_truck_lengths',
            'delete_truck_lengths',

            'access_truck_number_of_axles',
            'create_truck_number_of_axles',
            'edit_truck_number_of_axles',
            'delete_truck_number_of_axles',

            'access_truck_load_capacities',
            'create_truck_load_capacities',
            'edit_truck_load_capacities',
            'delete_truck_load_capacities',

            'access_trucks',
            'create_trucks',
            'edit_trucks',
            'delete_trucks',

            'access_shipments',
            'edit_shipments',
            'delete_shipments',


            'access_drivers',
            'create_drivers',
            'edit_drivers',
            'delete_drivers',

            'access_drivers_requests',
            'create_drivers_requests',
            'edit_drivers_requests',
            'delete_drivers_requests',

            'access_notifications',
            'create_notifications',
            'edit_notifications',
            'delete_notifications',
        ];

        foreach ($permissions as $permission) {
            Permission::create([
                'name' => $permission,
                'guard_name' => 'admin'
            ]);
        }

        $role = Role::create([
            'name' => 'Super Admin',
            'guard_name' => 'admin'
        ]);
        $role->givePermissionTo($permissions);

    }


}
