<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class AdminsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $routeName = $this->route()->getName();
            return [
                'name'=>'required',
                'email'=>$routeName=='admin.admins.update'?'nullable':'required|unique:admins,email',
                'mobile'=>$routeName=='admin.admins.update'?'nullable':'required|unique:admins,mobile',
                'role'=>'nullable',

            ];


    }
    public function messages()
    {
        return[
            'city_id.required'=>__('admin.city-required'),
            'ar.name.required'=>__('admin.name-required'),
            'ar.name.string'=>__('admin.string'),
        ];
    }
}
