<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class NotificationsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
            return [
                'title_ar'=>'required',
                'body_ar'=>'required',
                'user_id'=>['nullable',Rule::exists('users','id')],
                'driver_id'=>['nullable',Rule::exists('drivers','id')],
                'user_type'=>['required'],

            ];


    }
    public function messages()
    {
        return[
            'title.required'=>__('admin.title-required'),
            'body.required'=>__('admin.desc-required'),
            'user_type.required'=>__('admin.user_type-required'),
        ];
    }
}
