<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class TrucksRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'type_id' => ['required',Rule::exists('truck_types','id')],
            'catrgory_id' => ['required',Rule::exists('truck_categories','id')],
            'model_id' => ['required',Rule::exists('truck_models','id')],
            'length_id' => ['required',Rule::exists('truck_lengths','id')],
            'width_id' => ['required',Rule::exists('truck_widths','id')],
            'height_id' => ['required',Rule::exists('truck_heights','id')],
            'load_capacity_id' => ['required',Rule::exists('truck_load_capacities','id')],
            'number_of_axles_id' => ['required',Rule::exists('truck_number_of_axles','id')],
            'number' =>['required'],
            'color' =>['required'],
            'kilo_price' =>['required'],
            'added_by' => ['nullable']
        ];
    }
}
