<?php

namespace App\Http\Requests;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Validation\Rule;

class ShipmentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [

            'from_latitude' => 'required',
            'from_longitude' => 'required',
            'from_country_id' => 'required|exists:countries,id',
            'from_governorate_id' => 'required|exists:shipment_governorates,id',
            'from_city_id' => 'required|exists:shipment_cities,id',
            'from_address_name' => 'required',
            'from_street_name' => 'required',
            'from_description' => 'required',
            'to_latitude' => 'required',
            'to_longitude' => 'required',
            'to_country_id' => 'required',
            'to_governorate_id' => 'required|exists:shipment_governorates,id',
            'to_city_id' => 'required|exists:shipment_cities,id',
            'to_address_name' => 'required',
            'to_street_name' => 'required',
            'to_description' => 'required',

            'truck_type_id' => 'required|exists:truck_types,id',
            'truck_category_id' => 'required|exists:truck_categories,id',
            'truck_length_id' => 'required|exists:truck_lengths,id',
            'truck_width_id' => 'required|exists:truck_widths,id',
            'truck_height_id' => 'required|exists:truck_heights,id',
            'truck_load_capacity_id' => 'required|exists:truck_load_capacities,id',
            'truck_number_of_axles_id' => 'required|exists:truck_number_of_axles,id',

            'shipment_invoice_picture' => 'nullable',
            'packing_list_picture' => 'nullable',
            'receiver_mobile' => 'required',
            'shipment_type' => 'required',
            'shipment_weight' => 'required',
            'shipment_description' => 'required',
            'insurance_type_id' => 'nullable|exists:insurance_types,id',
            'packing_date' => 'required',
            'packing_time' => 'required',
            'number_of_trucks' => 'required',
        ];

    }
    protected function failedValidation(Validator $validator)
    {

        throw new HttpResponseException(apiResponse(401, 'errr',
            $this->stringifyErrors($validator->errors())
        ));
    }
    public static function stringifyErrors($errors): string
    {
        $errorsString = '';
        foreach ($errors->toArray() as $key => $error) {
            $i = 0;
            foreach ($error as $err) {
                if ($i > 0) {
                    $errorsString .= "\n";
                }

                $errorsString .= $err;
                $i++;
            }
        }
        return $errorsString;
    }

}
