<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class AddressDetailResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [

            'country' => new CountryResource($this->country) ,
            'governorate' => new GovernorateResource($this->governorate) ,
            'city' =>  new CityResource($this->city) ,
            'address_name' =>  $this->address_name ,
            'street_name' =>  $this->street_name ,
            'description' => $this->description ,
        ];
    }
}
