<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class DriverResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
    return [

        'id' => $this->id,
        'name' => $this->name,
        'mobile' => $this->mobile,
        'profile_image' => $this->profile_image,
        'identity_type' => $this->identity_type,
        'identity_card_number' => $this->identity_card_number,
        'other_identity_type' => $this->other_identity_type,
        'front_identity_card_image' => asset('images/drivers/front_identity_card_image').'/'.  $this->front_identity_card_image,
        'back_identity_card_image' => asset('images/drivers/back_identity_card_image').'/'. $this->back_identity_card_image,
        'passport_image' => asset('images/drivers/passport_image').'/'. $this->passport_image,
        'other_identity_image' => asset('images/drivers/other_identity_image').'/'. $this->other_identity_image,
        'price' => $this->price,
        'rates' => $this->rates,
         'token' => $this->token,
         'truck' =>  new TruckResource($this->truck) ,

    ];
    }
}

