<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class UserResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [

            'id' => $this->id,
            'name' => $this->name,
            'email' => $this->email,
            'mobile' => $this->mobile,
            'image' => $this->image,
            'rate' => $this->rate,
            'longitude' => $this->longitude,
            'latitude' => $this->latitude,
            'country' => $this->country->name_ar,
            'front_id_image' => asset('images').'/'. $this->front_id_image,
            'back_id_image' => asset('images').'/'. $this->back_id_image,
            'token' => $this->token,
            'online' => $this->online,


        ];
    }
}
