<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Shipment extends Model
{
    use HasFactory;

    protected $fillable = [
        'type',
        'weight',
        'insurance',
        'status',
        'description',
        'packing_date',
        'packing_time',
        'driver_id',
        'sender_id',
        'user_price',
        'driver_price',
        'final_price',
        'packing_from',
        'packing_to',
        'from_address_id',
        'from_address_detail_id',
        'shipment_date_id',
        'to_address_id',
        'to_address_detail_id',
        'receiver_id',
        'shipment_type',
        'shipment_weight',
        'truck_type_id',
        'truck_height_id',
        'truck_width_id',
        'truck_length_id',
        'truck_load_capacity_id',
        'truck_number_of_axles_id',
        'number_of_trucks',
        'insurance_type_id',
        'shipment_invoice_picture',
        'packing_list_picture',
        'truck_id',
        'accepted',
        'code',
        'shipment_id',
        'distance',
        'kilo_price'
];


    public function shipment(){
        return $this->belongsTo(Shipment::class);
    }

    public function setCodeAttribute($value)
    {
        // Only generate a new code if $value is not provided (i.e., when creating a new instance)
        if (!$value) {
            $this->attributes['code'] = $this->generateUniqueCode();
        } else {
            $this->attributes['code'] = $value;
        }
    }

    // Generate unique 4-digit code
    private function generateUniqueCode()
    {
        do {
            $code = str_pad(rand(0, 9999), 4, '0', STR_PAD_LEFT);
        } while (static::where('code', $code)->exists());

        return $code;
    }

    public function driver()
    {
        return $this->belongsTo(Driver::class , 'driver_id' ,'id');
    }

    public function sender()
    {
        return $this->belongsTo(User::class , 'sender_id' ,'id');
    }

    public function receiver()
    {
        return $this->belongsTo(User::class , 'receiver_id' ,'id');
    }

    public function from_address()
    {
        return $this->belongsTo(FromAddress::class , 'from_address_id' ,'id');
    }

    public function to_address()
    {
        return $this->belongsTo(ToAddress::class , 'to_address_id' ,'id');
    }

    public function from_address_details()
    {
        return $this->belongsTo(FromAddressDetail::class , 'from_address_detail_id' ,'id');
    }

    public function to_address_details()
    {
        return $this->belongsTo(ToAddressDetails::class , 'to_address_detail_id' ,'id');
    }

    public function truck()
    {
        return $this->belongsTo(Truck::class , 'truck_id' ,'id');
    }

    public function insurance_type()
    {
        return $this->belongsTo(InsuranceType::class , 'insurance_type_id' ,'id');
    }

    public function drivers()
    {
        return $this->belongsToMany(Driver::class , 'shipment_drivers' ,'shipment_id','driver_id')->withPivot(['price','app_price','tax'])->orderBy('shipment_drivers.created_at','desc');
    }
    public function selectedDriver()
    {
        return $this->belongsToMany(Driver::class , 'shipment_drivers' ,'shipment_id','driver_id')
            ->latest()
            ->where('shipment_drivers.status',1);
    }
    public function unAcceptedDriver()
    {
        return $this->belongsToMany(Driver::class , 'shipment_drivers' ,'shipment_id','driver_id')
            ->latest()
            ->where('shipment_drivers.status',0);
    }

}
