<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ShipmentGovernorate extends Model
{
    use HasFactory;

    protected $fillable = [
        'name_ar',
        'name_en',
        'shipment_country_id'
    ];
    public function country()
    {
        return $this->belongsTo(ShipmentCountry::class,'shipment_country_id','id');
    }
    public function cities()
    {
        return $this->hasMany(ShipmentCity::class,'shipment_governorate_id','id');
    }

}
