<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Slider extends Model
{
    use HasFactory;

    protected $fillable = [
        'image'
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];
    public function setImageAttribute($image){
        $image_name = time() . '-' . $image->getClientOriginalName();
        $image->move(public_path() . '/images/sliders/', $image_name);
        $this->attributes['image']=$image_name;
    }
    public function getImageAttribute($value){
        return  asset('images/sliders/').'/'.  $value;
    }

}
