<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Tymon\JWTAuth\Contracts\JWTSubject;
use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;


class User extends Authenticatable implements JWTSubject
{
    use HasFactory, Notifiable;


    protected $fillable = [
        'name',
        'status',
        'image',
        'email',
        'password',
        'mobile',
        'verification_code',
        'forget_code',
        'rate',
        'country_id',
        'front_id_image',
        'back_id_image',
        'wallet',
        'online'
    ];


    protected $hidden = [
        'password',
        'remember_token',
    ];


    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    public function getJWTCustomClaims()
    {
        return [];
    }


//    public function getImageAttribute($value){
////        dd(asset('images').'/');
//        return  asset('images').'/'.  $value;
//    }


    public function sender_shipments(){
        return $this->hasMany(Shipment::class , 'sender_id' ,'id');
    }

    public function receiver_shipments(){
        return $this->hasMany(Shipment::class , 'receiver_id' ,'id');
    }

    public function addresses(){
        return $this->hasMany(UserAdress::class , 'user_id' ,'id');
    }

    public function country(){
        return $this->belongsTo(Country::class , 'country_id' ,'id');
    }


    public function driver_rates(){
        return $this->belongsToMany(Driver::class , 'rates' , 'user_id' ,'driver_id')->withPivot('rate','comment');
    }


    public function messages(){
        return $this->belongsToMany(Driver::class , 'messages' , 'user_id' ,'driver_id')->withPivot('message','image');
    }





}
