@extends('admin.layouts.app')
@section('extra-css')
    <link href="{{asset('admin_assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}"
          id="bootstrap-style" rel="stylesheet"
          type="text/css"/>
    <link href="{{asset('admin_assets/libs/datatables.net-buttons-bs4/css/buttons.bootstrap4.min.css')}}"
          id="bootstrap-style" rel="stylesheet"
          type="text/css"/>
    <link href="{{asset('admin_assets/libs/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}"
          id="bootstrap-style" rel="stylesheet"
          type="text/css"/>

@endsection
@section('content')

    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">{{__('admin.forbidden-items')}}</h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">{{__('admin.Dashboard')}}</a>
                        </li>
                        <li class="breadcrumb-item active">{{__('admin.forbidden-items')}}</li>
                    </ol>
                </div>

            </div>
        </div>
    </div>
    <!-- end page title -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">

                    <form action="{{route('admin.forbidden-items.update',$item->id)}}" method="post" enctype="multipart/form-data">

                            @csrf
                            @method('PATCH')
                            <div class="tab-pane active" id="buy" role="tabpanel">

                                <div class="row">


                                    <div class="col-sm-12">


                                        <div class="mb-3">
                                            <label for="formrow-firstname-input"
                                                   class="form-label">   {{__('admin.title-field')}}  </label>
                                            <input type="text" name="title" value="{{$item->title}}" required
                                                   class="form-control" id="formrow-firstname-input"
                                                   placeholder="{{__('admin.title-field')}}">
                                        </div>

                                    </div>
                                    <div class="col-sm-12">

                                        <div class="mb-3">
                                            <label for="formrow-firstname-input" class="form-label">     {{__('admin.description')}}    </label>
                                            <textarea class="form-control" id="productdesc"  rows="5" required name="body" placeholder="{{__('admin.description')}}">{{$item->body}}</textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        <div class="col-lg-3">
                            <img style="width: 150px;height: 150px;" src="{{ asset('images/').'/'.$item->image}}">
                        </div>


                        <div class="mb-3">
                            <label for="formrow-firstname-input"
                                   class="form-label">    {{__('admin.img')}}  </label>
                            <input class="form-control" type="file" name="image"  id="formFile">
                        </div>
                        <div class="d-flex flex-wrap gap-2">
                            <button type="submit"
                                    class="btn btn-primary waves-effect waves-light"> {{__('admin.add')}}</button>

                        </div>

                    </form>

                </div>
            </div>


        </div>
    </div>

    <!-- end row -->
@endsection

@section('extra-js')
    <script src="{{asset('admin_assets/libs/select2/js/select2.min.js')}}"></script>
    <!-- bootstrap-datepicker js -->
    <script src="{{asset('admin_assets/libs/bootstrap-datepicker/js/bootstrap-datepicker.min.js')}}"></script>

    <!-- Required datatable js -->
    <script src="{{asset('admin_assets/libs/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('admin_assets/libs/datatables.net-bs4/js/dataTables.bootstrap4.min.js')}}"></script>

    <!-- Responsive examples -->
    <script src="{{asset('admin_assets/libs/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('admin_assets/libs/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>

    <!-- init js -->
    <script src="{{asset('admin_assets/js/pages/crypto-orders.init.js')}}"></script>


@endsection
