
@extends('admin.layouts.app')
@section('content')

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <h4 class="mb-sm-0 font-size-18">{{__('admin.admin-dashboard')}}</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">{{__('admin.admin-dashboard')}}</a></li>
                                <li class="breadcrumb-item active"> {{__('admin.dashboard')}}</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->

            <div class="row">
                <div class="col-xl-4">
                    <div class="card overflow-hidden">
                        <div class="bg-primary bg-soft">
                            <div class="row">
                                <div class="col-7">
                                    <div class="text-primary p-3">
                                        <h4 class="text-primary">{{__('admin.welcome-back')}}</h4>
                                        <p>{{__('admin.admin-dashboard')}}</p>
                                    </div>
                                </div>
                                <div class="col-5 align-self-end">
                                    <img src="{{auth()->guard('admin')->user()->img??asset('admin_assets/images/default-truck-image.jpeg')}}" alt="" class="img-fluid">
                                </div>
                            </div>
                        </div>
                        <div class="card-body pt-0">
                            <div class="row">
                                <div class="col-sm-4">
                                    <div class="avatar-md profile-user-wid mb-4">
                                        <img src="{{auth()->guard('admin')->user()->img??asset('admin_assets/images/default-truck-image.jpeg')}}" alt="" class="img-thumbnail rounded-circle">
                                    </div>
                                    <h5 class="font-size-15 text-truncate">{{auth()->guard('admin')->user()->name}}</h5>
{{--                                    <p class="text-muted mb-0 text-truncate">للتجارة الإلكترونية</p>--}}
                                </div>

                                <div class="col-sm-8">
                                    <div class="pt-4">

                                        <div class="row">
                                            <div class="col-6">
                                                <a href="{{route('admin.shipments.index')}}" target="_blank">
                                                <h5 class="font-size-15">{{$shipments}}</h5>
                                                <p class="text-muted mb-0">{{__('admin.shipments')}}</p>
                                                </a>
                                            </div>
                                            <div class="col-6">
                                                <h5 class="font-size-15">  {{$totalCost}}
                                                </h5>
                                                <p class="text-muted mb-0">{{__('admin.profits')}}</p>
                                            </div>
                                        </div>
{{--                                        <div class="mt-4">--}}
{{--                                            <a href="" class="btn btn-primary waves-effect waves-light btn-sm">{{__('admin.my-profile')}}<i class="mdi mdi-arrow-right ms-1"></i></a>--}}
{{--                                        </div>--}}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
{{--                    <div class="card">--}}
{{--                        <div class="card-body">--}}
{{--                            <h4 class="card-title mb-4">{{__('admin.monthly-income')}}</h4>--}}
{{--                            <div class="row">--}}
{{--                                <div class="col-sm-6">--}}
{{--                                    <p class="text-muted">{{__('admin.this-month')}}</p>--}}
{{--                                    <h3>--}}

{{--                                        {{$monthlyProfits}}--}}
{{--                                        {{$currency->value}}--}}
{{--                                    </h3>--}}
{{--                                    <p class="text-muted"><span class="@if($lessOrMore=='more') text-success @else text-danger @endif me-2"> {{$monthlyPreviousProfitsPercentage}}% <i class="mdi @if($lessOrMore=='more') mdi-arrow-up @else mdi-arrow-down @endif "></i> </span> {{__('admin.previous-month')}}</p>--}}

{{--                                    <div class="mt-4">--}}
{{--                                        <a href="javascript: void(0);" class="btn btn-primary waves-effect waves-light btn-sm">{{__('admin.view-more')}} <i class="mdi mdi-arrow-right ms-1"></i></a>--}}
{{--                                    </div>--}}
{{--                                </div>--}}
{{--                                <div class="col-sm-6">--}}
{{--                                    <div class="mt-4 mt-sm-0">--}}
{{--                                        <div id="radialBar-chart" data-colors='["--bs-primary"]' class="apex-charts"></div>--}}
{{--                                    </div>--}}
{{--                                </div>--}}
{{--                            </div>--}}
{{--                            <p class="text-muted mb-0">--}}
{{--                                {{__('admin.view-more')}}--}}

{{--                            </p>--}}
{{--                        </div>--}}
{{--                    </div>--}}
                </div>
                <div class="col-xl-8">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="card mini-stats-wid">
                                <div class="card-body">
                                    <div class="d-flex">
                                        <div class="flex-grow-1">
                                            <a href="{{route('admin.shipments.index')}}" target="_blank">

                                            <p class="text-muted fw-medium">{{__('admin.total-shipments')}}</p>
                                            <h4 class="mb-0">{{$shipments}}</h4>
                                            </a>
                                        </div>

                                        <div class="flex-shrink-0 align-self-center">
                                            <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                                                            <span class="avatar-title">
                                                                <i class="bx bx-check-shield font-size-24"></i>
                                                            </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card mini-stats-wid">
                                <div class="card-body">
                                    <div class="d-flex">
                                        <div class="flex-grow-1">
                                            <a href="{{route('admin.shipments.index',['status'=>4])}}" target="_blank">

                                            <p class="text-muted fw-medium">{{__('admin.finished-shipments')}}</p>
                                            <h4 class="mb-0"> {{$deliveredShipments}}</h4>
                                            </a>
                                        </div>

                                        <div class="flex-shrink-0 align-self-center ">
                                            <div class="avatar-sm rounded-circle bg-primary mini-stat-icon">
                                                            <span class="avatar-title rounded-circle ">
                                                                <i class="bx bx-cart-alt font-size-24"></i>
                                                            </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card mini-stats-wid">
                                <div class="card-body">
                                    <div class="d-flex">
                                        <div class="flex-grow-1">
                                            <a href="{{route('admin.shipments.index',['status'=>0])}}" target="_blank">

                                            <p class="text-muted fw-medium"> {{__('admin.pending-shipments')}} </p>
                                            <h4 class="mb-0"> {{$pendingShipments}}</h4>
                                            </a>
                                        </div>

                                        <div class="flex-shrink-0 align-self-center">
                                            <div class="avatar-sm rounded-circle bg-primary mini-stat-icon">
                                                            <span class="avatar-title rounded-circle ">
                                                                <i class="bx bx-analyse font-size-24"></i>
                                                            </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-3">
                            <div class="card mini-stats-wid">
                                <div class="card-body">
                                    <div class="d-flex">
                                        <div class="flex-grow-1">
                                            <a href="{{route('admin.shipments.index',['status'=>1])}}" target="_blank">

                                            <p class="text-muted fw-medium">{{__('admin.packing-shipments')}}</p>
                                            <h4 class="mb-0">{{$packingShipments}}</h4>
                                            </a>
                                        </div>

                                        <div class="flex-shrink-0 align-self-center">
                                            <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                                                            <span class="avatar-title">
                                                                <i class="bx bx-check-square font-size-24"></i>
                                                            </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card mini-stats-wid">
                                <div class="card-body">
                                    <div class="d-flex">
                                        <div class="flex-grow-1">
                                            <a href="{{route('admin.shipments.index',['status'=>2])}}" target="_blank">

                                            <p class="text-muted fw-medium">{{__('admin.packed-shipments')}}</p>
                                            <h4 class="mb-0"> {{$packedShipments}}</h4>
                                            </a>
                                        </div>

                                        <div class="flex-shrink-0 align-self-center ">
                                            <div class="avatar-sm rounded-circle bg-primary mini-stat-icon">
                                                            <span class="avatar-title rounded-circle ">
                                                                <i class="bx bxs-truck font-size-24"></i>
                                                            </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card mini-stats-wid">
                                <div class="card-body">
                                    <div class="d-flex">
                                        <div class="flex-grow-1">
                                            <a href="{{route('admin.shipments.index',['status'=>3])}}" target="_blank">

                                            <p class="text-muted fw-medium"> {{__('admin.delivering-shipments')}} </p>
                                            <h4 class="mb-0"> {{$deliveringShipments}}</h4>
                                            </a>
                                        </div>

                                        <div class="flex-shrink-0 align-self-center">
                                            <div class="avatar-sm rounded-circle bg-primary mini-stat-icon">
                                                            <span class="avatar-title rounded-circle ">
                                                                <i class="bx bx-user font-size-24"></i>
                                                            </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- end row -->


                </div>
            </div>
            <div class="row">
                <div class="card">
                    <div class="card-body">
                        <div class="d-sm-flex flex-wrap">
                            <h4 class="card-title mb-4"> {{__('admin.shipments-statistics')}}</h4>
                            <div class="ms-auto">
                            </div>
                        </div>

                        <div id="stacked-column-chart" class="apex-charts" data-colors='["--bs-primary", "--bs-warning", "--bs-success"]' dir="ltr"></div>
                    </div>
                </div>

            </div>
            <!-- end row -->

            <div class="row">

                    <div class="card">
                        <div class="card-body">
                            <div class="d-sm-flex flex-wrap">
                                <h4 class="card-title mb-4"> {{__('admin.users-statistics')}}</h4>
                                <div class="ms-auto">
                                </div>
                            </div>

                            <div id="stacked-column-chart2" class="apex-charts" data-colors='["--bs-primary", "--bs-warning", "--bs-success"]' dir="ltr"></div>
                        </div>
                    </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="card-title mb-4"> {{__('admin.latest-shipments')}} </h4>
                            <div class="table-responsive">
                                <table class="table align-middle table-nowrap table-check">
                                    <thead class="table-light">
                                    <tr>


                                        <th scope="col">{{__('admin.id')}}</th>
                                        <th scope="col">{{__('admin.type')}}</th>
                                        <th scope="col">{{__('admin.weight')}}</th>
                                        <th scope="col">{{__('admin.insurance_type')}}</th>
                                        <th scope="col">{{__('admin.status')}}</th>
                                        <th scope="col">{{__('admin.description')}}</th>
                                        <th scope="col">{{__('admin.driver')}}</th>
                                        <th scope="col">{{__('admin.sender')}}</th>
                                        <th scope="col">{{__('admin.user_price')}}</th>
                                        <th scope="col">{{__('admin.driver_price')}}</th>
                                        <th scope="col">{{__('admin.final_price')}}</th>
                                        <th scope="col">{{__('admin.packing_date')}}</th>
                                        <th scope="col">{{__('admin.packing_time')}}</th>
                                        <th scope="col">{{__('admin.from_address')}}</th>
                                        <th scope="col">{{__('admin.from_address_detail')}}</th>
                                        <th scope="col">{{__('admin.to_address')}}</th>
                                        <th scope="col">{{__('admin.to_address_detail')}}</th>
                                        <th scope="col">{{__('admin.receiver')}}</th>
                                        <th scope="col">{{__('admin.truck')}}</th>
                                        <th scope="col">{{__('admin.number_of_trucks')}}</th>
                                        <th scope="col">{{__('admin.shipment_invoice_picture')}}</th>
                                        <th scope="col">{{__('admin.packing_list_picture')}}</th>
                                        <th scope="col">{{__('admin.created_at')}}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($latestShipments as $shipment)

                                        <tr>
                                            <td><a  class="text-body fw-bold">{{$shipment->id}}</a></td>
                                            <td>
                                                {{$shipment->type}}
                                            </td>
                                            <td>
                                                {{$shipment->weight}}
                                            </td>
                                            <td>
                                                {{$shipment->insurance_type?->type}}
                                            </td>
                                            <td>
                                    <span class="badge badge-pill badge-soft-success font-size-12">
                                        @if($shipment->status==0)
                                            {{__('admin.pending')}}
                                        @elseif($shipment->status==1)
                                            {{__('admin.packing')}}

                                        @elseif($shipment->status==2)
                                            {{__('admin.packed')}}
                                        @elseif($shipment->status==3)
                                            {{__('admin.delivering')}}
                                        @else
                                            {{__('admin.delivered')}}

                                        @endif
                                    </span>
                                            </td>
                                            <td>
                                                {{$shipment->description}}
                                            </td>
                                            <td>
                                                {{$shipment->drivers()->where('shipment_drivers.status',1)->first()->name}}
                                            </td>
                                            <td>
                                                {{$shipment->sender->name}}
                                            </td>
                                            <td>
                                                {{$shipment->user_price}}
                                            </td>
                                            <td>
                                                {{$shipment->driver_price}}
                                            </td>
                                            <td>
                                                {{$shipment->final_price}}
                                            </td>
                                            <td>
                                                {{$shipment->packing_date}}
                                            </td>
                                            <td>
                                                {{$shipment->packing_time}}
                                            </td>
                                            <td>
{{--                                                <a target="_blank" href="https://maps.google.com/maps/search/?q={{$shipment->from_address->latitude}},{{$shipment->from_address->longitude}}&hl=es&z=14&output=embed">--}}
{{--                                                    {{__('admin.location')}}--}}
{{--                                                </a>--}}

                                            </td>

                                            <td>
                                                {{$shipment->from_address_details?->address_name}}
                                            </td>
                                            <td>
                                                <a target="_blank" href="https://maps.google.com/maps/search/?q={{$shipment->to_address->latitude}},{{$shipment->to_address->longitude}}&hl=es&z=14&output=embed">
                                                {{__('admin.location')}}
                                                </a>

                                            </td>
                                            <td>
                                                {{$shipment->to_address_details?->address_name}}
                                            </td>
                                            <td>
                                                {{$shipment->receiver?->name}}
                                            </td>
                                            <td>
                                                {{$shipment->truck?$shipment->truck->type?->type_ar:'-'}}
                                            </td>
                                            <td>
                                                {{$shipment->number_of_trucks}}
                                            </td>
                                            <td>
                                              <img width="150px" height="150px" src="{{asset('images/'.$shipment->shipment_invoice_picture)}}">
                                            </td>
                                            <td>
                                              <img width="150px" height="150px" src="{{asset('images/'.$shipment->packing_list_picture)}}">
                                            </td>
                                            <td>
                                                {{Carbon\Carbon::parse($shipment->created_at)->locale('ar')->translatedFormat('l dS F G:i - Y')}}
                                            </td>
                                        </tr>
                                    @endforeach


                                    </tbody>
                                </table>
                            </div>
                            <!-- end table-responsive -->
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="card-title mb-4"> {{__('admin.latest-users')}} </h4>
                            <div class="table-responsive">
                                <table class="table align-middle table-nowrap table-check">
                                    <thead class="table-light">
                                    <tr>


                                        <th scope="col">{{__('admin.id')}}</th>
                                        <th scope="col">{{__('admin.img')}}</th>

                                        <th scope="col">{{__('admin.name')}}</th>
                                        <th scope="col">{{__('admin.phone')}}</th>
                                        {{--                                <th scope="col">{{__('admin.status')}}</th>--}}
                                        <th scope="col">{{__('admin.created_at')}}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($latestUsers as $user)

                                        <tr>
                                            <td><a  class="text-body fw-bold">{{$user->id}}</a></td>
                                            <td>
                                                <a href="{{$user->image?asset('images/users/').'/'. $user->image:asset('admin_assets/images/users/user.png')}} " target="_blank" class="text-body fw-bold">

                                                    <img class="rounded-circle header-profile-user" src="{{$user->image?asset('images/users/').'/'. $user->image:asset('admin_assets/images/users/user.png')}}"
                                                         alt="Header Avatar">
                                                </a>
                                            </td>

                                            <td>{{$user->name}}</td>
                                            <td style="direction: ltr;"><a href="tel:{{$user->mobile}}"> {{$user->mobile}} </a></td>
                                            {{--                                    <td>--}}
                                            {{--                                        <div class="form-check form-switch form-switch-lg mb-3" dir="ltr">--}}
                                            {{--                                            <input class="form-check-input" type="checkbox"--}}
                                            {{--                                                   onchange="return window.location.href = '{{route('admin.users.change-status',$user->id)}}'"--}}
                                            {{--                                                   @if($user->verified==3)checked="" @endif>--}}

                                            {{--                                        </div>--}}
                                            {{--                                    </td>--}}

                                            <td>
                                                {{Carbon\Carbon::parse($user->created_at)->locale('ar')->translatedFormat('l dS F G:i - Y')}}
                                            </td>
                                        </tr>
                                    @endforeach


                                    </tbody>
                                </table>
                            </div>
                            <!-- end table-responsive -->
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="card-title mb-4"> {{__('admin.latest-divers')}} </h4>
                            <div class="table-responsive">
                                <table class="table align-middle table-nowrap table-check">
                                    <thead class="table-light">
                                    <tr>


                                        <th scope="col">{{__('admin.id')}}</th>
                                        <th scope="col">{{__('admin.img')}}</th>

                                        <th scope="col">{{__('admin.name')}}</th>
                                        <th scope="col">{{__('admin.phone')}}</th>
                                        {{--                                <th scope="col">{{__('admin.status')}}</th>--}}
                                        <th scope="col">{{__('admin.created_at')}}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($latestDrivers as $driver)

                                        <tr>
                                            <td><a  class="text-body fw-bold">{{$driver->id}}</a></td>
                                            <td>
                                                <a href="{{asset('images/').'/'. $driver->profile_image}}" target="_blank" class="text-body fw-bold">

                                                    <img class="rounded-circle header-profile-user" src="{{asset('images/'.$driver->profile_image)}}"
                                                         alt="Header Avatar">
                                                </a>
                                            </td>

                                            <td>{{$driver->name}}</td>
                                            <td style="direction: ltr;"><a href="tel:{{$driver->mobile}}"> {{$driver->mobile}} </a></td>
                                            {{--                                    <td>--}}
                                            {{--                                        <div class="form-check form-switch form-switch-lg mb-3" dir="ltr">--}}
                                            {{--                                            <input class="form-check-input" type="checkbox"--}}
                                            {{--                                                   onchange="return window.location.href = '{{route('admin.users.change-status',$user->id)}}'"--}}
                                            {{--                                                   @if($user->verified==3)checked="" @endif>--}}

                                            {{--                                        </div>--}}
                                            {{--                                    </td>--}}

                                            <td>
                                                {{Carbon\Carbon::parse($driver->created_at)->locale('ar')->translatedFormat('l dS F G:i - Y')}}
                                            </td>
                                        </tr>
                                    @endforeach


                                    </tbody>
                                </table>
                            </div>
                            <!-- end table-responsive -->
                        </div>
                    </div>
                </div>
            </div>

            <!-- end row -->

@endsection
@section('extra-js')
    <script src="{{asset('admin_assets/libs/apexcharts/apexcharts.min.js')}}"></script>
    <script>
        function getChartColorsArray(e) {
            if (null !== document.getElementById(e)) {
                var t = document.getElementById(e).getAttribute("data-colors");
                if (t) return (t = JSON.parse(t)).map(function (e) {
                    var t = e.replace(" ", "");
                    if (-1 === t.indexOf(",")) {
                        var r = getComputedStyle(document.documentElement).getPropertyValue(t);
                        return r || t
                    }
                    var a = e.split(",");
                    return 2 != a.length ? t : "rgba(" + getComputedStyle(document.documentElement).getPropertyValue(a[0]) + "," + a[1] + ")"
                })
            }
        }
        setTimeout(function () {
            $("#subscribeModal").modal("show")
        }, 2e3);
        var linechartBasicColors = getChartColorsArray("stacked-column-chart");
        linechartBasicColors && (options = {
            chart: {
                height: 360,
                type: "bar",
                stacked: !0,
                toolbar: {
                    show: !1
                },
                zoom: {
                    enabled: !0
                }
            },
            plotOptions: {
                bar: {
                    horizontal: !1,
                    columnWidth: "15%",
                    endingShape: "rounded"
                }
            },
            dataLabels: {
                enabled: !1
            },
            series: [{
                name: "{{__('admin.pending-shipments')}}",
                data: [
                    {{$pendingShipments11}},
                    {{$pendingShipments10}},
                    {{$pendingShipments9}},
                    {{$pendingShipments8}},
                    {{$pendingShipments7}},
                    {{$pendingShipments6}},
                    {{$pendingShipments5}},
                    {{$pendingShipments4}},
                    {{$pendingShipments3}},
                    {{$pendingShipments2}},
                    {{$pendingShipments1}},
                    {{$pendingShipments}}]
            }, {
                name: "{{__('admin.delivered-shipments')}}",
                data: [
                    {{$deliveredShipments11}},
                    {{$deliveredShipments10}},
                    {{$deliveredShipments9}},
                    {{$deliveredShipments8}},
                    {{$deliveredShipments7}},
                    {{$deliveredShipments6}},
                    {{$deliveredShipments5}},
                    {{$deliveredShipments4}},
                    {{$deliveredShipments3}},
                    {{$deliveredShipments2}},
                    {{$deliveredShipments1}},
                    {{$deliveredShipments}}]
            }, {
                name: "{{__('admin.packed-shipments')}}",
                data: [{{$packedShipments}}, {{$packedShipments11}}, {{$packedShipments10}}, {{$packedShipments9}}, {{$packedShipments8}}, {{$packedShipments7}}, {{$packedShipments6}}, {{$packedShipments5}}, {{$packedShipments4}}, {{$packedShipments3}}, {{$packedShipments2}}, {{$packedShipments1}}]
            }],
            xaxis: {
                categories: [
                    "{{Carbon\Carbon::now()->subMonths(11)->locale('ar')->translatedFormat('F')}}",
                    "{{Carbon\Carbon::now()->subMonths(10)->locale('ar')->translatedFormat('F')}}",
                    "{{Carbon\Carbon::now()->subMonths(9)->locale('ar')->translatedFormat('F')}}",
                    "{{Carbon\Carbon::now()->subMonths(8)->locale('ar')->translatedFormat('F')}}",
                    "{{Carbon\Carbon::now()->subMonths(7)->locale('ar')->translatedFormat('F')}}",
                    "{{Carbon\Carbon::now()->subMonths(6)->locale('ar')->translatedFormat('F')}}",
                    "{{Carbon\Carbon::now()->subMonths(5)->locale('ar')->translatedFormat('F')}}",
                    "{{Carbon\Carbon::now()->subMonths(4)->locale('ar')->translatedFormat('F')}}",
                    "{{Carbon\Carbon::now()->subMonths(3)->locale('ar')->translatedFormat('F')}}",
                    "{{Carbon\Carbon::now()->subMonths(2)->locale('ar')->translatedFormat('F')}}",
                    "{{Carbon\Carbon::now()->subMonth()->locale('ar')->translatedFormat('F')}}"
                    ,"{{Carbon\Carbon::now()->locale('ar')->translatedFormat('F')}}"
                ]


            },
            colors: linechartBasicColors,
            legend: {
                position: "bottom"
            },
            fill: {
                opacity: 1
            }
        }

            , (chart = new ApexCharts(document.querySelector("#stacked-column-chart"), options)).render());

        var linechartBasicColors = getChartColorsArray("stacked-column-chart2");
        linechartBasicColors && (options = {
            chart: {
                height: 360,
                type: "bar",
                stacked: !0,
                toolbar: {
                    show: !1
                },
                zoom: {
                    enabled: !0
                }
            },
            plotOptions: {
                bar: {
                    horizontal: !1,
                    columnWidth: "15%",
                    endingShape: "rounded"
                }
            },
            dataLabels: {
                enabled: !1
            },
            series: [{
                name: "{{__('admin.all-users')}}",
                data: [
                    {{$users11}},
                    {{$users10}},
                    {{$users9}},
                    {{$users8}},
                    {{$users7}},
                    {{$users6}},
                    {{$users5}},
                    {{$users4}},
                    {{$users3}},
                    {{$users2}},
                    {{$users1}},
                    {{$users}}
                ]
            }, {
                name: "{{__('admin.all-drivers')}}",
                data: [
                    {{$drivers11}},
                    {{$drivers10}},
                    {{$drivers9}},
                    {{$drivers8}},
                    {{$drivers7}},
                    {{$drivers6}},
                    {{$drivers5}},
                    {{$drivers4}},
                    {{$drivers3}},
                    {{$drivers2}},
                    {{$drivers1}},
                    {{$drivers}}
                ]
            }],
            xaxis: {
                categories: [
                    "{{Carbon\Carbon::now()->subMonths(11)->locale('ar')->translatedFormat('F')}}",
                    "{{Carbon\Carbon::now()->subMonths(10)->locale('ar')->translatedFormat('F')}}",
                    "{{Carbon\Carbon::now()->subMonths(9)->locale('ar')->translatedFormat('F')}}",
                    "{{Carbon\Carbon::now()->subMonths(8)->locale('ar')->translatedFormat('F')}}",
                    "{{Carbon\Carbon::now()->subMonths(7)->locale('ar')->translatedFormat('F')}}",
                    "{{Carbon\Carbon::now()->subMonths(6)->locale('ar')->translatedFormat('F')}}",
                    "{{Carbon\Carbon::now()->subMonths(5)->locale('ar')->translatedFormat('F')}}",
                    "{{Carbon\Carbon::now()->subMonths(4)->locale('ar')->translatedFormat('F')}}",
                    "{{Carbon\Carbon::now()->subMonths(3)->locale('ar')->translatedFormat('F')}}",
                    "{{Carbon\Carbon::now()->subMonths(2)->locale('ar')->translatedFormat('F')}}",
                    "{{Carbon\Carbon::now()->subMonth()->locale('ar')->translatedFormat('F')}}"
                    ,"{{Carbon\Carbon::now()->locale('ar')->translatedFormat('F')}}"
                    ]

            },
            colors: linechartBasicColors,
            legend: {
                position: "bottom"
            },
            fill: {
                opacity: 1
            }
        }

            , (chart = new ApexCharts(document.querySelector("#stacked-column-chart2"), options)).render());
        {{--var options, chart, radialbarColors = getChartColorsArray("radialBar-chart");--}}
        {{--radialbarColors && (options = {--}}
        {{--    chart: {--}}
        {{--        height: 200,--}}
        {{--        type: "radialBar",--}}
        {{--        offsetY: -10--}}
        {{--    },--}}
        {{--    plotOptions: {--}}
        {{--        radialBar: {--}}
        {{--            startAngle: -135,--}}
        {{--            endAngle: 135,--}}
        {{--            dataLabels: {--}}
        {{--                name: {--}}
        {{--                    fontSize: "13px",--}}
        {{--                    color: void 0,--}}
        {{--                    offsetY: 60--}}
        {{--                },--}}
        {{--                value: {--}}
        {{--                    offsetY: 22,--}}
        {{--                    fontSize: "16px",--}}
        {{--                    color: void 0,--}}
        {{--                    formatter: function (e) {--}}
        {{--                        return e + "%"--}}
        {{--                    }--}}
        {{--                }--}}
        {{--            }--}}
        {{--        }--}}
        {{--    },--}}
        {{--    colors: radialbarColors,--}}
        {{--    fill: {--}}
        {{--        type: "gradient",--}}
        {{--        gradient: {--}}
        {{--            shade: "dark",--}}
        {{--            shadeIntensity: .15,--}}
        {{--            inverseColors: !1,--}}
        {{--            opacityFrom: 1,--}}
        {{--            opacityTo: 1,--}}
        {{--            stops: [0, 50, 65, 91]--}}
        {{--        }--}}
        {{--    },--}}
        {{--    stroke: {--}}
        {{--        dashArray: 4--}}
        {{--    },--}}
        {{--    series: [{{$monthlyProfitsPercentage}}],--}}
        {{--    labels: ["معدل الزيادة هذا الشهر"]--}}
        {{--}, (chart = new ApexCharts(document.querySelector("#radialBar-chart"), options)).render());--}}
    </script>

    <!-- dashboard init -->


@endsection
