@extends('admin.layouts.app')
@section('extra-css')
    <link href="{{asset('admin_assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}"
          id="bootstrap-style" rel="stylesheet"
          type="text/css"/>
    <link href="{{asset('admin_assets/libs/datatables.net-buttons-bs4/css/buttons.bootstrap4.min.css')}}"
          id="bootstrap-style" rel="stylesheet"
          type="text/css"/>
    <link href="{{asset('admin_assets/libs/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}"
          id="bootstrap-style" rel="stylesheet"
          type="text/css"/>

@endsection
@section('content')

    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">{{__('admin.roles')}}</h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">{{__('admin.Dashboard')}}</a>
                        </li>
                        <li class="breadcrumb-item active">{{__('admin.roles')}}</li>
                    </ol>
                </div>

            </div>
        </div>
    </div>
    <!-- end page title -->

    <!-- start page title -->
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <form action="{{route('admin.roles.update',$role->id)}}" method="post" enctype="multipart/form-data">
                @csrf
                @method('PATCH')

                <div class="card">
                    <div class="card-body">
                        <div class="row">


                            <div class="col-sm-12">


                                <div class="mb-3">
                                    <label for="formrow-firstname-input"
                                           class="form-label">   {{__('admin.role_name')}}  </label>
                                    <input type="text" value="{{$role->name}}" class="form-control" name="name" required
                                           id="formrow-firstname-input"
                                           placeholder="{{__('admin.please-enter-role-name')}}">
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
                <div class="card">

                    <div class="card-body">
                        <h4 class="card-title mb-4">{{__('admin.permissions')}}</h4>
                        <div class="form-check mb-4">
                            <input class="form-check-input custom-checkbox" type="checkbox" id="select-all"
                                   name="select-all" @if(count($role->permissions)==95) checked @endif>
                            <label class="form-check-label mt-4px" for="select-all">
                                {{__('admin.give_all_permissions')}}
                            </label>


                        </div>

                        <div class="row">


                            <div class="col-xl-3 col-sm-6">
                                <div class="mt-4 mt-xl-0">
                                    <h4 class="font-size-14 mb-3">{{__('admin.statistics')}}</h4>
                                    <div class="docs-toggles">
                                        <ul class="list-group">
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" id="access_statistics"
                                                           name="permissions[]"
                                                           value="access_statistics" {{ $role->hasPermissionTo('access_statistics') ? 'checked' : '' }}>
                                                    <label for="access_statistics"
                                                           class="form-check-label">{{__('admin.access_statistics')}}</label>

                                                </div>
                                            </li>


                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="mt-4 mt-xl-0">
                                    <h4 class="font-size-14 mb-3">{{__('admin.about_app')}}</h4>
                                    <div class="docs-toggles">
                                        <ul class="list-group">
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" id="access_about_app"
                                                           name="permissions[]"
                                                           value="access_about_app" {{ $role->hasPermissionTo('access_about_app') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="access_about_app">{{__('admin.access_about_app')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox"
                                                           id="edit_about_app" name="permissions[]"
                                                           value="edit_about_app" {{ $role->hasPermissionTo('edit_about_app') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="edit_about_app">{{__('admin.edit_about_app')}}</label>
                                                </div>
                                            </li>

                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="mt-4 mt-xl-0">
                                    <h4 class="font-size-14 mb-3">{{__('admin.terms_and_conditions')}}</h4>
                                    <div class="docs-toggles">
                                        <ul class="list-group">
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="access_terms_and_conditions" type="checkbox"
                                                           name="permissions[]"
                                                           value="access_terms_and_conditions" {{ $role->hasPermissionTo('access_terms_and_conditions') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="access_terms_and_conditions">{{__('admin.access_terms_and_conditions')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="edit_terms_and_conditions" type="checkbox"
                                                           name="permissions[]"
                                                           value="edit_terms_and_conditions" {{ $role->hasPermissionTo('edit_terms_and_conditions') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="edit_terms_and_conditions">{{__('admin.edit_terms_and_conditions')}}</label>
                                                </div>
                                            </li>

                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="mt-4 mt-xl-0">
                                    <h4 class="font-size-14 mb-3">{{__('admin.privacy_policy')}}</h4>
                                    <div class="docs-toggles">
                                        <ul class="list-group">
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="access_privacy_policy" type="checkbox"
                                                           name="permissions[]"
                                                           value="access_privacy_policy" {{ $role->hasPermissionTo('access_privacy_policy') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="access_privacy_policy">{{__('admin.access_privacy_policy')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="edit_privacy_policy" type="checkbox"
                                                           name="permissions[]"
                                                           value="edit_privacy_policy" {{ $role->hasPermissionTo('edit_privacy_policy') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="edit_privacy_policy">{{__('admin.edit_privacy_policy')}}</label>
                                                </div>
                                            </li>

                                        </ul>
                                    </div>
                                </div>
                            </div>


                        </div>
                        <div class="row mt-3">


                            <div class="col-xl-3 col-sm-6">
                                <div class="mt-4 mt-xl-0">
                                    <h4 class="font-size-14 mb-3">{{__('admin.technical_support')}}</h4>
                                    <div class="docs-toggles">
                                        <ul class="list-group">
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="access_technical_support" type="checkbox"
                                                           name="permissions[]"
                                                           value="access_technical_support" {{ $role->hasPermissionTo('access_technical_support') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="access_technical_support">{{__('admin.access_technical_support')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="delete_technical_support" type="checkbox"
                                                           name="permissions[]"
                                                           value="delete_technical_support" {{ $role->hasPermissionTo('delete_technical_support') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="delete_technical_support">{{__('admin.delete_technical_support')}}</label>
                                                </div>
                                            </li>

                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="mt-4 mt-xl-0">
                                    <h4 class="font-size-14 mb-3">{{__('admin.countries')}}</h4>
                                    <div class="docs-toggles">
                                        <ul class="list-group">
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="access_countries" type="checkbox"
                                                           name="permissions[]"
                                                           value="access_countries" {{ $role->hasPermissionTo('access_countries') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="access_countries">{{__('admin.access_countries')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="create_countries" type="checkbox"
                                                           name="permissions[]"
                                                           value="create_countries" {{ $role->hasPermissionTo('create_countries') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="create_countries">{{__('admin.create_countries')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="edit_countries" type="checkbox"
                                                           name="permissions[]"
                                                           value="edit_countries" {{ $role->hasPermissionTo('edit_countries') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="edit_countries">{{__('admin.edit_countries')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="delete_countries" type="checkbox"
                                                           name="permissions[]"
                                                           value="delete_countries" {{ $role->hasPermissionTo('delete_countries') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="delete_countries">{{__('admin.delete_countries')}}</label>
                                                </div>
                                            </li>

                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="mt-4 mt-xl-0">
                                    <h4 class="font-size-14 mb-3">{{__('admin.shipments_countries')}}</h4>
                                    <div class="docs-toggles">
                                        <ul class="list-group">
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="access_shipments_countries" type="checkbox"
                                                           name="permissions[]"
                                                           value="access_shipments_countries" {{ $role->hasPermissionTo('access_shipments_countries') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="access_shipments_countries">{{__('admin.access_shipments_countries')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="create_shipments_countries" type="checkbox"
                                                           name="permissions[]"
                                                           value="create_shipments_countries" {{ $role->hasPermissionTo('create_shipments_countries') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="create_shipments_countries">{{__('admin.create_shipments_countries')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="edit_shipments_countries" type="checkbox"
                                                           name="permissions[]"
                                                           value="edit_shipments_countries" {{ $role->hasPermissionTo('edit_shipments_countries') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="edit_shipments_countries">{{__('admin.edit_shipments_countries')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="delete_shipments_countries" type="checkbox"
                                                           name="permissions[]"
                                                           value="delete_shipments_countries" {{ $role->hasPermissionTo('delete_shipments_countries') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="delete_shipments_countries">{{__('admin.delete_shipments_countries')}}</label>
                                                </div>
                                            </li>

                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="mt-4 mt-xl-0">
                                    <h4 class="font-size-14 mb-3">{{__('admin.shipments_governorates')}}</h4>
                                    <div class="docs-toggles">
                                        <ul class="list-group">
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="access_shipments_governorates" type="checkbox"
                                                           name="permissions[]"
                                                           value="access_shipments_governorates" {{ $role->hasPermissionTo('access_shipments_governorates') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="access_shipments_governorates">{{__('admin.access_shipments_governorates')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="create_shipments_governorates"
                                                           type="checkbox" name="permissions[]"
                                                           value="create_shipments_governorates" {{ $role->hasPermissionTo('create_shipments_governorates') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="create_shipments_governorates">{{__('admin.create_shipments_governorates')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="edit_shipments_governorates"
                                                           type="checkbox" name="permissions[]"
                                                           value="edit_shipments_governorates" {{ $role->hasPermissionTo('edit_shipments_governorates') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="edit_shipments_governorates">{{__('admin.edit_shipments_governorates')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="delete_shipments_governorates"
                                                           type="checkbox" name="permissions[]"
                                                           value="delete_shipments_governorates" {{ $role->hasPermissionTo('delete_shipments_governorates') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="delete_shipments_governorates">{{__('admin.delete_shipments_governorates')}}</label>
                                                </div>
                                            </li>

                                        </ul>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div class="row mt-3">

                            <div class="col-xl-3 col-sm-6">
                                <div class="mt-4 mt-xl-0">
                                    <h4 class="font-size-14 mb-3">{{__('admin.shipments_cities')}}</h4>
                                    <div class="docs-toggles">
                                        <ul class="list-group">
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="access_shipments_cities" type="checkbox"
                                                           name="permissions[]"
                                                           value="access_shipments_cities" {{ $role->hasPermissionTo('access_shipments_cities') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="access_shipments_cities">{{__('admin.access_shipments_cities')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="create_shipments_cities" type="checkbox"
                                                           name="permissions[]"
                                                           value="create_shipments_cities" {{ $role->hasPermissionTo('create_shipments_cities') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="create_shipments_cities">{{__('admin.create_shipments_cities')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="edit_shipments_cities" type="checkbox"
                                                           name="permissions[]"
                                                           value="edit_shipments_cities" {{ $role->hasPermissionTo('edit_shipments_cities') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="edit_shipments_cities">{{__('admin.edit_shipments_cities')}}</label>
                                                </div>
                                            </li>

                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="delete_shipments_cities" type="checkbox"
                                                           name="permissions[]"
                                                           value="delete_shipments_cities" {{ $role->hasPermissionTo('delete_shipments_cities') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="delete_shipments_cities">{{__('admin.delete_shipments_cities')}}</label>
                                                </div>
                                            </li>

                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="mt-4 mt-xl-0">
                                    <h4 class="font-size-14 mb-3">{{__('admin.users')}}</h4>
                                    <div class="docs-toggles">
                                        <ul class="list-group">
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="access_users" type="checkbox"
                                                           name="permissions[]"
                                                           value="access_users" {{ $role->hasPermissionTo('access_users') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="access_users">{{__('admin.access_users')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="edit_users" type="checkbox"
                                                           name="permissions[]"
                                                           value="edit_users" {{ $role->hasPermissionTo('edit_users') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="edit_users">{{__('admin.edit_users')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="delete_users" type="checkbox"
                                                           name="permissions[]"
                                                           value="delete_users" {{ $role->hasPermissionTo('delete_users') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="delete_users">{{__('admin.delete_users')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="update_status_users" type="checkbox"
                                                           name="permissions[]"
                                                           value="update_status_users" {{ $role->hasPermissionTo('update_status_users') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="update_status_users">{{__('admin.update_status_users')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="access_shipments_users" type="checkbox"
                                                           name="permissions[]"
                                                           value="access_shipments_users" {{ $role->hasPermissionTo('access_shipments_users') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="access_shipments_users">{{__('admin.access_shipments_users')}}</label>
                                                </div>
                                            </li>

                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="mt-4 mt-xl-0">
                                    <h4 class="font-size-14 mb-3">{{__('admin.forbidden_items')}}</h4>
                                    <div class="docs-toggles">
                                        <ul class="list-group">
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="access_forbidden_items" type="checkbox"
                                                           name="permissions[]"
                                                           value="access_forbidden_items" {{ $role->hasPermissionTo('access_forbidden_items') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="access_forbidden_items">{{__('admin.access_forbidden_items')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="create_forbidden_items" type="checkbox"
                                                           name="permissions[]"
                                                           value="create_forbidden_items" {{ $role->hasPermissionTo('create_forbidden_items') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="create_forbidden_items">{{__('admin.create_forbidden_items')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="edit_forbidden_items" type="checkbox"
                                                           name="permissions[]"
                                                           value="edit_forbidden_items" {{ $role->hasPermissionTo('edit_forbidden_items') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="edit_forbidden_items">{{__('admin.edit_forbidden_items')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="delete_forbidden_items" type="checkbox"
                                                           name="permissions[]"
                                                           value="delete_forbidden_items" {{ $role->hasPermissionTo('delete_forbidden_items') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="delete_forbidden_items">{{__('admin.delete_forbidden_items')}}</label>
                                                </div>
                                            </li>

                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="mt-4 mt-xl-0">
                                    <h4 class="font-size-14 mb-3">{{__('admin.shipments')}}</h4>
                                    <div class="docs-toggles">
                                        <ul class="list-group">
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="access_shipments" type="checkbox"
                                                           name="permissions[]"
                                                           value="access_shipments" {{ $role->hasPermissionTo('access_shipments') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="access_shipments">{{__('admin.access_shipments')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="edit_shipments" type="checkbox"
                                                           name="permissions[]"
                                                           value="edit_shipments" {{ $role->hasPermissionTo('edit_shipments') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="edit_shipments">{{__('admin.edit_shipments')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="delete_shipments" type="checkbox"
                                                           name="permissions[]"
                                                           value="delete_shipments" {{ $role->hasPermissionTo('delete_shipments') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="delete_shipments">{{__('admin.delete_shipments')}}</label>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div class="row mt-3">

                            <div class="col-xl-3 col-sm-6">
                                <div class="mt-4 mt-xl-0">
                                    <h4 class="font-size-14 mb-3">{{__('admin.truck_categories')}}</h4>
                                    <div class="docs-toggles">
                                        <ul class="list-group">
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="access_truck_categories" type="checkbox"
                                                           name="permissions[]"
                                                           value="access_truck_categories" {{ $role->hasPermissionTo('access_truck_categories') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="access_truck_categories">{{__('admin.access_truck_categories')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="create_truck_categories"
                                                           type="checkbox" name="permissions[]"
                                                           value="create_truck_categories" {{ $role->hasPermissionTo('create_truck_categories') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="create_truck_categories">{{__('admin.create_truck_categories')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="edit_truck_categories"
                                                           type="checkbox" name="permissions[]"
                                                           value="edit_truck_categories" {{ $role->hasPermissionTo('edit_truck_categories') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="edit_truck_categories">{{__('admin.edit_truck_categories')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="delete_truck_categories"
                                                           type="checkbox" name="permissions[]"
                                                           value="delete_truck_categories" {{ $role->hasPermissionTo('delete_truck_categories') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="delete_truck_categories">{{__('admin.delete_truck_categories')}}</label>
                                                </div>
                                            </li>

                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="mt-4 mt-xl-0">
                                    <h4 class="font-size-14 mb-3">{{__('admin.truck_types')}}</h4>
                                    <div class="docs-toggles">
                                        <ul class="list-group">
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="access_truck_types" type="checkbox"
                                                           name="permissions[]"
                                                           value="access_truck_types" {{ $role->hasPermissionTo('access_truck_types') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="access_truck_types">{{__('admin.access_truck_types')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="create_truck_types" type="checkbox"
                                                           name="permissions[]"
                                                           value="create_truck_types" {{ $role->hasPermissionTo('create_truck_types') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="create_truck_types">{{__('admin.create_truck_types')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="edit_truck_types" type="checkbox"
                                                           name="permissions[]"
                                                           value="edit_truck_types" {{ $role->hasPermissionTo('edit_truck_types') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="edit_truck_types">{{__('admin.edit_truck_types')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="delete_truck_types" type="checkbox"
                                                           name="permissions[]"
                                                           value="delete_truck_types" {{ $role->hasPermissionTo('delete_truck_types') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="delete_truck_types">{{__('admin.delete_truck_types')}}</label>
                                                </div>
                                            </li>

                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="mt-4 mt-xl-0">
                                    <h4 class="font-size-14 mb-3">{{__('admin.truck_models')}}</h4>
                                    <div class="docs-toggles">
                                        <ul class="list-group">
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="access_truck_models" type="checkbox"
                                                           name="permissions[]"
                                                           value="access_truck_models" {{ $role->hasPermissionTo('access_truck_models') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="access_truck_models">{{__('admin.access_truck_models')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="create_truck_models" type="checkbox"
                                                           name="permissions[]"
                                                           value="create_truck_models" {{ $role->hasPermissionTo('create_truck_models') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="create_truck_models">{{__('admin.create_truck_models')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="edit_truck_models" type="checkbox"
                                                           name="permissions[]"
                                                           value="edit_truck_models" {{ $role->hasPermissionTo('edit_truck_models') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="edit_truck_models">{{__('admin.edit_truck_models')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="delete_truck_models" type="checkbox"
                                                           name="permissions[]"
                                                           value="delete_truck_models" {{ $role->hasPermissionTo('delete_truck_models') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="delete_truck_models">{{__('admin.delete_truck_models')}}</label>
                                                </div>
                                            </li>

                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="mt-4 mt-xl-0">
                                    <h4 class="font-size-14 mb-3">{{__('admin.truck_heights')}}</h4>
                                    <div class="docs-toggles">
                                        <ul class="list-group">
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="access_truck_heights" type="checkbox"
                                                           name="permissions[]"
                                                           value="access_truck_heights" {{ $role->hasPermissionTo('access_truck_heights') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="access_truck_heights">{{__('admin.access_truck_heights')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="create_truck_heights" type="checkbox"
                                                           name="permissions[]"
                                                           value="create_truck_heights" {{ $role->hasPermissionTo('create_truck_heights') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="create_truck_heights">{{__('admin.create_truck_heights')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="edit_truck_heights" type="checkbox"
                                                           name="permissions[]"
                                                           value="edit_truck_heights" {{ $role->hasPermissionTo('edit_truck_heights') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="edit_truck_heights">{{__('admin.edit_truck_heights')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="delete_truck_heights" type="checkbox"
                                                           name="permissions[]"
                                                           value="delete_truck_heights" {{ $role->hasPermissionTo('delete_truck_heights') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="delete_truck_heights">{{__('admin.delete_truck_heights')}}</label>
                                                </div>
                                            </li>

                                        </ul>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div class="row mt-3">

                            <div class="col-xl-3 col-sm-6">
                                <div class="mt-4 mt-xl-0">
                                    <h4 class="font-size-14 mb-3">{{__('admin.truck_widths')}}</h4>
                                    <div class="docs-toggles">
                                        <ul class="list-group">
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="access_truck_widths" type="checkbox"
                                                           name="permissions[]"
                                                           value="access_truck_widths" {{ $role->hasPermissionTo('access_truck_widths') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="access_truck_widths">{{__('admin.access_truck_widths')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="create_truck_widths" type="checkbox"
                                                           name="permissions[]"
                                                           value="create_truck_widths" {{ $role->hasPermissionTo('create_truck_widths') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="create_truck_widths">{{__('admin.create_truck_widths')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="edit_truck_widths" type="checkbox"
                                                           name="permissions[]"
                                                           value="edit_truck_widths" {{ $role->hasPermissionTo('edit_truck_widths') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="edit_truck_widths">{{__('admin.edit_truck_widths')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="delete_truck_widths" type="checkbox"
                                                           name="permissions[]"
                                                           value="delete_truck_widths" {{ $role->hasPermissionTo('delete_truck_widths') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="delete_truck_widths">{{__('admin.delete_truck_widths')}}</label>
                                                </div>
                                            </li>

                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="mt-4 mt-xl-0">
                                    <h4 class="font-size-14 mb-3">{{__('admin.truck_lengths')}}</h4>
                                    <div class="docs-toggles">
                                        <ul class="list-group">
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="access_truck_lengths" type="checkbox"
                                                           name="permissions[]"
                                                           value="access_truck_lengths" {{ $role->hasPermissionTo('access_truck_lengths') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="access_truck_lengths">{{__('admin.access_truck_lengths')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="create_truck_lengths" type="checkbox"
                                                           name="permissions[]"
                                                           value="create_truck_lengths" {{ $role->hasPermissionTo('create_truck_lengths') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="create_truck_lengths">{{__('admin.create_truck_lengths')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="edit_truck_lengths" type="checkbox"
                                                           name="permissions[]"
                                                           value="edit_truck_lengths" {{ $role->hasPermissionTo('edit_truck_lengths') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="edit_truck_lengths">{{__('admin.edit_truck_lengths')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="delete_truck_lengths" type="checkbox"
                                                           name="permissions[]"
                                                           value="delete_truck_lengths" {{ $role->hasPermissionTo('delete_truck_lengths') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="delete_truck_lengths">{{__('admin.delete_truck_lengths')}}</label>
                                                </div>
                                            </li>

                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="mt-4 mt-xl-0">
                                    <h4 class="font-size-14 mb-3">{{__('admin.truck_number_of_axles')}}</h4>
                                    <div class="docs-toggles">
                                        <ul class="list-group">
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="access_truck_number_of_axles" type="checkbox"
                                                           name="permissions[]"
                                                           value="access_truck_number_of_axles" {{ $role->hasPermissionTo('access_truck_number_of_axles') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="access_truck_number_of_axles">{{__('admin.access_truck_number_of_axles')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="create_truck_number_of_axles" type="checkbox"
                                                           name="permissions[]"
                                                           value="create_truck_number_of_axles" {{ $role->hasPermissionTo('create_truck_number_of_axles') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="create_truck_number_of_axles">{{__('admin.create_truck_number_of_axles')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="edit_truck_number_of_axles" type="checkbox"
                                                           name="permissions[]"
                                                           value="edit_truck_number_of_axles" {{ $role->hasPermissionTo('edit_truck_number_of_axles') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="edit_truck_number_of_axles">{{__('admin.edit_truck_number_of_axles')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="delete_truck_number_of_axles" type="checkbox"
                                                           name="permissions[]"
                                                           value="delete_truck_number_of_axles" {{ $role->hasPermissionTo('delete_truck_number_of_axles') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="delete_truck_number_of_axles">{{__('admin.delete_truck_number_of_axles')}}</label>
                                                </div>
                                            </li>

                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="mt-4 mt-xl-0">
                                    <h4 class="font-size-14 mb-3">{{__('admin.truck_load_capacities')}}</h4>
                                    <div class="docs-toggles">
                                        <ul class="list-group">
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="access_truck_load_capacities" type="checkbox"
                                                           name="permissions[]"
                                                           value="access_truck_load_capacities" {{ $role->hasPermissionTo('access_truck_load_capacities') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="access_truck_load_capacities">{{__('admin.access_truck_load_capacities')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="create_truck_load_capacities" type="checkbox"
                                                           name="permissions[]"
                                                           value="create_truck_load_capacities" {{ $role->hasPermissionTo('create_truck_load_capacities') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="create_truck_load_capacities">{{__('admin.create_truck_load_capacities')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="edit_truck_load_capacities" type="checkbox"
                                                           name="permissions[]"
                                                           value="edit_truck_load_capacities" {{ $role->hasPermissionTo('edit_truck_load_capacities') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="edit_truck_load_capacities">{{__('admin.edit_truck_load_capacities')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="delete_truck_load_capacities" type="checkbox"
                                                           name="permissions[]"
                                                           value="delete_truck_load_capacities" {{ $role->hasPermissionTo('delete_truck_load_capacities') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="delete_truck_load_capacities">{{__('admin.delete_truck_load_capacities')}}</label>
                                                </div>
                                            </li>

                                        </ul>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div class="row mt-3">

                            <div class="col-xl-3 col-sm-6">
                                <div class="mt-4 mt-xl-0">
                                    <h4 class="font-size-14 mb-3">{{__('admin.trucks')}}</h4>
                                    <div class="docs-toggles">
                                        <ul class="list-group">
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="access_trucks" type="checkbox"
                                                           name="permissions[]"
                                                           value="access_trucks" {{ $role->hasPermissionTo('access_trucks') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="access_trucks">{{__('admin.access_trucks')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="create_trucks" type="checkbox"
                                                           name="permissions[]"
                                                           value="create_trucks" {{ $role->hasPermissionTo('create_trucks') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="create_trucks">{{__('admin.create_trucks')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="edit_trucks" type="checkbox"
                                                           name="permissions[]"
                                                           value="edit_trucks" {{ $role->hasPermissionTo('edit_trucks') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="edit_trucks">{{__('admin.edit_trucks')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="delete_trucks" type="checkbox"
                                                           name="permissions[]"
                                                           value="delete_trucks" {{ $role->hasPermissionTo('delete_trucks') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="delete_trucks">{{__('admin.delete_trucks')}}</label>
                                                </div>
                                            </li>

                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="mt-4 mt-xl-0">
                                    <h4 class="font-size-14 mb-3">{{__('admin.drivers')}}</h4>
                                    <div class="docs-toggles">
                                        <ul class="list-group">
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="access_drivers" type="checkbox"
                                                           name="permissions[]"
                                                           value="access_drivers" {{ $role->hasPermissionTo('access_drivers') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="access_drivers">{{__('admin.access_drivers')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="create_drivers" type="checkbox"
                                                           name="permissions[]"
                                                           value="create_drivers" {{ $role->hasPermissionTo('create_drivers') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="create_drivers">{{__('admin.create_drivers')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="edit_drivers" type="checkbox"
                                                           name="permissions[]"
                                                           value="edit_drivers" {{ $role->hasPermissionTo('edit_drivers') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="edit_drivers">{{__('admin.edit_drivers')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="delete_drivers" type="checkbox"
                                                           name="permissions[]"
                                                           value="delete_drivers" {{ $role->hasPermissionTo('delete_drivers') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="delete_drivers">{{__('admin.delete_drivers')}}</label>
                                                </div>
                                            </li>

                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="mt-4 mt-xl-0">
                                    <h4 class="font-size-14 mb-3">{{__('admin.drivers_requests')}}</h4>
                                    <div class="docs-toggles">
                                        <ul class="list-group">
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="access_drivers_requests" type="checkbox"
                                                           name="permissions[]"
                                                           value="access_drivers_requests" {{ $role->hasPermissionTo('access_drivers_requests') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="access_drivers_requests">{{__('admin.access_drivers_requests')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="create_drivers_requests" type="checkbox"
                                                           name="permissions[]"
                                                           value="create_drivers_requests" {{ $role->hasPermissionTo('create_drivers_requests') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="create_drivers_requests">{{__('admin.create_drivers_requests')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="edit_drivers_requests" type="checkbox"
                                                           name="permissions[]"
                                                           value="edit_drivers_requests" {{ $role->hasPermissionTo('edit_drivers_requests') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="edit_drivers_requests">{{__('admin.edit_drivers_requests')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="delete_drivers_requests" type="checkbox"
                                                           name="permissions[]"
                                                           value="delete_drivers_requests" {{ $role->hasPermissionTo('delete_drivers_requests') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="delete_drivers_requests">{{__('admin.delete_drivers_requests')}}</label>
                                                </div>
                                            </li>

                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="mt-4 mt-xl-0">
                                    <h4 class="font-size-14 mb-3">{{__('admin.notifications')}}</h4>
                                    <div class="docs-toggles">
                                        <ul class="list-group">
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="access_notifications" type="checkbox"
                                                           name="permissions[]"
                                                           value="access_notifications" {{ $role->hasPermissionTo('access_notifications') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="access_notifications">{{__('admin.access_notifications')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="create_notifications" type="checkbox"
                                                           name="permissions[]"
                                                           value="create_notifications" {{ $role->hasPermissionTo('create_notifications') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="create_notifications">{{__('admin.create_notifications')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="edit_notifications" type="checkbox"
                                                           name="permissions[]"
                                                           value="edit_notifications" {{ $role->hasPermissionTo('edit_notifications') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="edit_notifications">{{__('admin.edit_notifications')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="delete_notifications" type="checkbox"
                                                           name="permissions[]"
                                                           value="delete_notifications" {{ $role->hasPermissionTo('delete_notifications') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="delete_notifications">{{__('admin.delete_notifications')}}</label>
                                                </div>
                                            </li>

                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row mt-3">

                            <div class="col-xl-3 col-sm-6">
                                <div class="mt-4 mt-xl-0">
                                    <h4 class="font-size-14 mb-3">{{__('admin.suggestions')}}</h4>
                                    <div class="docs-toggles">
                                        <ul class="list-group">
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="access_suggestions" type="checkbox"
                                                           name="permissions[]"
                                                           value="access_suggestions" {{ $role->hasPermissionTo('access_suggestions') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="access_suggestions">{{__('admin.access_suggestions')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="edit_suggestions" type="checkbox"
                                                           name="permissions[]"
                                                           value="edit_suggestions" {{ $role->hasPermissionTo('edit_suggestions') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="edit_suggestions">{{__('admin.edit_suggestions')}}</label>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="mt-4 mt-xl-0">

                                    <h4 class="font-size-14 mb-3">{{__('admin.shippers')}}</h4>
                                    <div class="docs-toggles">
                                        <ul class="list-group">
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="access_shippers" type="checkbox"
                                                           name="permissions[]"
                                                           value="access_shippers" {{ $role->hasPermissionTo('access_shippers') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="access_shippers">{{__('admin.access_shippers')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="create_shippers" type="checkbox"
                                                           name="permissions[]"
                                                           value="create_shippers" {{ $role->hasPermissionTo('create_shippers') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="create_shippers">{{__('admin.create_shippers')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="edit_shippers" type="checkbox"
                                                           name="permissions[]"
                                                           value="edit_shippers" {{ $role->hasPermissionTo('edit_shippers') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="edit_shippers">{{__('admin.edit_shippers')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="delete_shippers" type="checkbox"
                                                           name="permissions[]"
                                                           value="delete_shippers" {{ $role->hasPermissionTo('delete_shippers') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="delete_shippers">{{__('admin.delete_shippers')}}</label>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="mt-4 mt-xl-0">

                                    <h4 class="font-size-14 mb-3">{{__('admin.sliders')}}</h4>
                                    <div class="docs-toggles">
                                        <ul class="list-group">
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="access_sliders" type="checkbox"
                                                           name="permissions[]"
                                                           value="access_sliders" {{ $role->hasPermissionTo('access_sliders') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="access_sliders">{{__('admin.access_sliders')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="create_sliders" type="checkbox"
                                                           name="permissions[]"
                                                           value="create_sliders" {{ $role->hasPermissionTo('create_sliders') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="create_sliders">{{__('admin.create_sliders')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="edit_sliders" type="checkbox"
                                                           name="permissions[]"
                                                           value="edit_sliders" {{ $role->hasPermissionTo('edit_sliders') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="edit_sliders">{{__('admin.edit_sliders')}}</label>
                                                </div>
                                            </li>
                                            <li class="list-group-item">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="delete_sliders" type="checkbox"
                                                           name="permissions[]"
                                                           value="delete_sliders" {{ $role->hasPermissionTo('delete_sliders') ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="delete_sliders">{{__('admin.delete_sliders')}}</label>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>

                        </div>


                    </div>

                    <div class="d-flex flex-wrap gap-2 mt-3">
                        <button type="submit"
                                class="btn btn-primary waves-effect waves-light"> {{__('admin.edit')}}  </button>

                    </div>

                </div>


            </form>

        </div>

    </div>
    </div>
    <!-- end row -->
@endsection

@section('extra-js')
    <script src="{{asset('admin_assets/libs/select2/js/select2.min.js')}}"></script>
    <!-- bootstrap-datepicker js -->
    <script src="{{asset('admin_assets/libs/bootstrap-datepicker/js/bootstrap-datepicker.min.js')}}"></script>

    <!-- Required datatable js -->
    <script src="{{asset('admin_assets/libs/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('admin_assets/libs/datatables.net-bs4/js/dataTables.bootstrap4.min.js')}}"></script>

    <!-- Responsive examples -->
    <script src="{{asset('admin_assets/libs/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('admin_assets/libs/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>

    <!-- init js -->
    <script src="{{asset('admin_assets/js/pages/crypto-orders.init.js')}}"></script>

    <script>
        $(document).ready(function () {
            $('#select-all').click(function () {
                var checked = this.checked;
                $('input[type="checkbox"]').each(function () {
                    this.checked = checked;
                });
            })
        });
    </script>

@endsection
