@extends('shipper.layouts.app')
@section('extra-css')
    <link href="{{asset('admin_assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}"
          id="bootstrap-style" rel="stylesheet"
          type="text/css"/>
    <link href="{{asset('admin_assets/libs/datatables.net-buttons-bs4/css/buttons.bootstrap4.min.css')}}"
          id="bootstrap-style" rel="stylesheet"
          type="text/css"/>
    <link href="{{asset('admin_assets/libs/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}"
          id="bootstrap-style" rel="stylesheet"
          type="text/css"/>

@endsection
@section('content')

    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">{{__('admin.shipments')}}</h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">{{__('admin.Dashboard')}}</a>
                        </li>
                        <li class="breadcrumb-item active">{{__('admin.shipments')}}</li>
                    </ol>
                </div>

            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row mb-2">
                        <div class="col-sm-4">
                        </div>
{{--                        @can('create_categories')--}}

{{--                        @endcan--}}
                    </div>
                    <form  method="get" action="{{route('shipper.shipments.index')}}">
                        <input type="hidden" name="driver_id" value="{{request('driver_id')}}">
                        <div class="row">

                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label for="formrow-email-input"
                                           class="form-label">{{__('admin.status')}}</label>
                                    <select id="formrow-inputState" class="form-select" name="status">
                                        <option selected="" disabled> {{__('admin.status')}}</option>
                                            <option value="0" @if(request('status') && request('status')==0) selected @endif>{{__('admin.waiting')}}</option>
                                            <option value="1" @if(request('status')==1) selected @endif>{{__('admin.packing_in_progress')}}</option>
                                            <option value="2" @if(request('status')==2) selected @endif>{{__('admin.Packed')}}</option>
                                            <option value="3" @if(request('status')==3) selected @endif>{{__('admin.in_delivery')}}</option>
                                            <option value="4" @if(request('status')==4) selected @endif>{{__('admin.delivered')}}</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label for="formrow-email-input"
                                           class="form-label">{{__('admin.from-date')}}</label>
                                    <input name="from" class="form-control" type="date" value="{{old('from')??request('from')}}"
                                           id="example-date-input">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label for="formrow-password-input"
                                           class="form-label">{{__('admin.to-date')}}</label>
                                    <input name="to" class="form-control" type="date" value="{{old('to')??request('to')}}"
                                           id="example-date-input">
                                </div>
                            </div>
                            <div class="col-md-2 ">
                                <div class="d-grid">
                                    <label for="formrow-email-input"
                                           class="form-label hidden">{{__('admin.search')}}</label>
                                    <input data-repeater-delete="" type="submit"
                                           class="btn btn-primary inner" value="{{__('admin.search')}}">
                                </div>
                            </div>
                        </div>
                    </form>

                    <div class="table-responsive mt-2">
                        <table class="table table-hover  dt-responsive nowrap"
                               style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                            <thead>
                            <tr class="tr-colored">
                                <th scope="col">{{__('admin.id')}}</th>
                                <th scope="col">{{__('admin.type')}}</th>
                                <th scope="col">{{__('admin.weight')}}</th>
                                <th scope="col">{{__('admin.insurance_type')}}</th>
                                <th scope="col">{{__('admin.status')}}</th>
                                <th scope="col">{{__('admin.description')}}</th>
                                <th scope="col">{{__('admin.driver')}}</th>
                                <th scope="col">{{__('admin.sender')}}</th>
                                <th scope="col">{{__('admin.user_price')}}</th>
                                <th scope="col">{{__('admin.driver_price')}}</th>
                                <th scope="col">{{__('admin.final_price')}}</th>
                                <th scope="col">{{__('admin.packing_date')}}</th>
                                <th scope="col">{{__('admin.packing_time')}}</th>
                                <th scope="col">{{__('admin.from_address')}}</th>
                                <th scope="col">{{__('admin.from_address_detail')}}</th>
                                <th scope="col">{{__('admin.to_address')}}</th>
                                <th scope="col">{{__('admin.to_address_detail')}}</th>
                                <th scope="col">{{__('admin.receiver')}}</th>
                                <th scope="col">{{__('admin.truck')}}</th>
                                <th scope="col">{{__('admin.number_of_trucks')}}</th>
                                <th scope="col">{{__('admin.shipment_invoice_picture')}}</th>
                                <th scope="col">{{__('admin.packing_list_picture')}}</th>
                                <th scope="col">{{__('admin.created_at')}}</th>
                                <th scope="col">{{__('admin.more')}}</th>

                            </tr>
                            </thead>
                            <tbody>
                            @foreach($shipments as $shipment)

                                <tr>
                                    <td><a href="#" class="text-body fw-bold">{{$shipment->id}}</a></td>
                                    <td>
                                        {{$shipment->type}}
                                    </td>
                                    <td>
                                        {{$shipment->weight}}
                                    </td>
                                    <td>
                                        {{$shipment->insurance_type?__('admin.'.$shipment->insurance_type->type):'-'}}
                                    </td>
                                    <td>
                                    <span class="badge badge-pill badge-soft-success font-size-12">
                                        @if($shipment->status==0)
                                            {{__('admin.pending')}}
                                        @elseif($shipment->status==1)
                                            {{__('admin.packing')}}

                                        @elseif($shipment->status==2)
                                            {{__('admin.packed')}}
                                        @elseif($shipment->status==3)
                                            {{__('admin.delivering')}}
                                        @else
                                            {{__('admin.delivered')}}

                                        @endif
                                    </span>
                                    </td>
                                    <td>
                                        {{$shipment->description}}
                                    </td>
                                    <td>
                                        {{$shipment->drivers()->where('shipment_drivers.status',1)->first()?->name}}
                                    </td>
                                    <td>
                                        {{$shipment->sender->name}}
                                    </td>
                                    <td>
                                        {{$shipment->user_price}}
                                    </td>
                                    <td>
                                        {{$shipment->driver_price}}
                                    </td>
                                    <td>
                                        {{$shipment->final_price}}
                                    </td>
                                    <td>
                                        {{$shipment->packing_date}}
                                    </td>
                                    <td>
                                        {{$shipment->packing_time}}
                                    </td>
                                    <td>
                                        <a target="_blank" href="https://maps.google.com/maps/search/?q={{$shipment->from_address->latitude}},{{$shipment->from_address->longitude}}&hl=es&z=14&output=embed">
                                            {{__('admin.location')}}
                                        </a>

                                    </td>

                                    <td>
                                        {{$shipment->from_address_details?->address_name}}
                                    </td>
                                    <td>
                                        <a target="_blank" href="https://maps.google.com/maps/search/?q={{$shipment->to_address->latitude}},{{$shipment->to_address->longitude}}&hl=es&z=14&output=embed">
                                            {{__('admin.location')}}
                                        </a>

                                    </td>
                                    <td>
                                        {{$shipment->to_address_details?->address_name}}
                                    </td>
                                    <td>
                                        {{$shipment->receiver?->name}}
                                    </td>
                                    <td>
                                        {{$shipment->truck?$shipment->truck->type?->type_ar:'-'}}
                                    </td>
                                    <td>
                                        {{$shipment->number_of_trucks}}
                                    </td>
                                    <td>
                                        <img width="150px" height="150px" src="{{asset('images/'.$shipment->shipment_invoice_picture)}}">
                                    </td>
                                    <td>
                                        <img width="150px" height="150px" src="{{asset('images/'.$shipment->packing_list_picture)}}">
                                    </td>
                                    <td>
                                        {{Carbon\Carbon::parse($shipment->created_at)->locale('ar')->translatedFormat('l dS F G:i - Y')}}
                                    </td>
                                    <td>
                                        <div class="d-flex gap-3">
                                            <a href="{{route('shipper.shipments.show',$shipment->id)}}" title="{{__('admin.show')}}" class="text-success"><i class="mdi mdi-eye font-size-18"></i></a>

                                            <a onclick="openModalDelete({{$shipment->id}})" title="{{__('admin.delete')}}" class="text-danger">
                                                <i class="mdi mdi-delete font-size-18"></i>
                                            </a>
                                        </div>
                                    </td>

                                </tr>
                            @endforeach


                            </tbody>
                        </table>
                    </div>
                    {{$shipments->withQueryString()->links('shipper.pagination.bootstrap-4')}}

                </div>
            </div>
        </div>
    </div>
    <!-- end row -->
@endsection

@section('extra-js')
    <script src="{{asset('admin_assets/libs/select2/js/select2.min.js')}}"></script>
    <!-- bootstrap-datepicker js -->
    <script src="{{asset('admin_assets/libs/bootstrap-datepicker/js/bootstrap-datepicker.min.js')}}"></script>

    <!-- Required datatable js -->
    <script src="{{asset('admin_assets/libs/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('admin_assets/libs/datatables.net-bs4/js/dataTables.bootstrap4.min.js')}}"></script>

    <!-- Responsive examples -->
    <script src="{{asset('admin_assets/libs/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('admin_assets/libs/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>

    <!-- init js -->
    <script src="{{asset('admin_assets/js/pages/crypto-orders.init.js')}}"></script>

    <script>
        function openModalDelete(city_id) {
            $('.action_form').attr('action', '{{route('shipper.shipments.destroy', '')}}' + '/' + city_id);
            $('#deleteModal').modal('show');
        }
    </script>

@endsection
@section('modal')
@component('admin.layouts.includes.modal')
    @slot('modalID')
        deleteModal
    @endslot
    @slot('modalTitle')
        {{__('admin.delete-data')}}
    @endslot
    @slot('modalMethodPutOrDelete')
        @method('delete')
    @endslot
    @slot('modalContent')
        <div class="text-center">
                <span class="text-danger font-16">
                    {{__('admin.delete-message-confirm')}}
                </span>
        </div>
    @endslot
@endcomponent
@endsection
