<?php

use App\Http\Controllers\Api\Users\MessageController;
use App\Http\Controllers\Api\Users\NotificationController;
use App\Http\Controllers\Api\Users\SettingController;
use App\Http\Controllers\Api\Users\ShipmentController;
use App\Http\Controllers\Api\Users\UserAuthController;
use App\Http\Controllers\Api\Users\UserController;
use App\Http\Controllers\Api\Drivers\DriverShipmentController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::group(['prefix' => 'users'], function () {

    Route::group(['prefix' => 'auth'], function () {

        Route::get('countries', [UserAuthController::class, 'list_countries']);


        Route::get('send_email/{email}/{message}', [UserAuthController::class, 'send_email']);


        Route::post('register', [UserAuthController::class, 'register']);
        Route::post('verify-code', [UserAuthController::class, 'verifyCode']);
        Route::post('update', [UserAuthController::class, 'update_user']);
        Route::post('login', [UserAuthController::class, 'login']);
        Route::post('logout', [UserAuthController::class, 'logout']);
        Route::post('forget-password', [UserAuthController::class, 'forgetPassword']);
        Route::post('check-forget-code', [UserAuthController::class, 'check_forget_code']);
        Route::post('reset-password', [UserAuthController::class, 'resetPassword']);
        Route::get('generate-beams-token', [UserAuthController::class, 'generateAuthToken']);
        Route::get('online-status/{status}', [UserAuthController::class, 'onlineStatus']);
        Route::get('delete/{id}', [UserAuthController::class, 'delete']);

    });

    Route::group(['prefix' => 'setting'], function () {

        Route::get('about-app', [SettingController::class, 'list_about_app']);
        Route::get('terms-and-conditions', [SettingController::class, 'list_terms_and_conditions']);
        Route::get('privacy-policy', [SettingController::class, 'list_privacy_policy']);
        Route::post('technical-support', [SettingController::class, 'technical_support']);
        Route::post('suggestions', [SettingController::class, 'send_suggestion']);
        Route::get('insurance', [SettingController::class, 'insurance_details']);
        Route::get('sliders', [SettingController::class, 'sliders']);
        Route::get('how_shipment', [SettingController::class, 'how_shipment']);
    });

});


Route::group(['prefix' => 'users'], function () {

    Route::group(['prefix' => 'shipment'], function () {

        Route::get('list', [ShipmentController::class, 'get_shipment_data']);
        Route::get('governorates/{country_id}', [ShipmentController::class, 'governorates']);
        Route::get('cities/{governorate_id}', [ShipmentController::class, 'cities']);
        Route::get('details/{shipment_id}', [ShipmentController::class, 'get_shipment_details']);
        Route::post('save', [ShipmentController::class, 'save_shipment']);
        Route::post('drivers', [ShipmentController::class, 'get_drivers']);
        Route::get('export', [ShipmentController::class, 'current_export_shipments']);
        Route::get('import', [ShipmentController::class, 'current_import_shipments']);
        Route::get('export/previous', [ShipmentController::class, 'previous_export_shipments']);
        Route::get('import/previous', [ShipmentController::class, 'previous_import_shipments']);
        Route::get('cancel/{shipment}', [ShipmentController::class, 'cancel_shipment']);
        Route::post('search', [ShipmentController::class, 'search']);
        Route::post('custom-price', [ShipmentController::class, 'custom_price']);
        Route::get('forbidden-items', [ShipmentController::class, 'forbidden_items']);
        // Route::post('accept-driver',[ShipmentController::class , 'select_driver']);
        Route::post('reject-driver', [ShipmentController::class, 'remove_driver']);
        Route::post('accept-driver', [ShipmentController::class, 'accept_driver']);


    });

    Route::group(['prefix' => 'profile'], function () {

        Route::post('change-password', [UserController::class, 'change_password']);
        Route::post('save-location', [UserController::class, 'saveLocation']);
        Route::post('add-address', [UserController::class, 'add_address']);
        Route::get('my-addresses', [UserController::class, 'my_addresses']);
        Route::get('my-address-details', [UserController::class, 'my_address_details']);
        Route::get('delete-address/{address}', [UserController::class, 'delete_address']);
        Route::post('update', [UserController::class, 'update_profile']);
        Route::get('wallet', [UserController::class, 'wallet']);
    });

    Route::group(['prefix' => 'rates'], function () {

        Route::get('', [UserController::class, 'my_rates']);
        Route::post('add-rate', [UserController::class, 'add_rate']);
    });


    Route::group(['prefix' => 'messages'], function () {

        Route::get('/', [MessageController::class, 'messages']);
        Route::post('/chat', [MessageController::class, 'chat_messages']);
        Route::post('send', [MessageController::class, 'send_message']);
    });


    Route::group(['prefix' => 'notifications'], function () {

        Route::get('/', [NotificationController::class, 'notifications']);
    });
});


