<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Academy;
use App\Models\Category;
use App\Models\User;
use App\Models\AcademyCrew;
use App\Models\Job;
use App\Models\JobTitle;
use App\Models\Course;
use App\Models\CourseUser;
use App\Models\VonHistory;
use App\Models\Notification;




class AcademyController extends Controller
{
    public function academies(Request $request)
     {
        $academies = Academy::select('id','name','image','category_id','user_id','type')->where('user_id',$request->user_id)->get();
        
        
        foreach($academies as $academy){
            $academy->image = asset('images/').'/'.$academy->image;
            $academy->category = Category::select('id','name')->where('id',$academy->category_id)->first();
            $academy->crews = AcademyCrew::select('id','crew_id','title_id')->where('academy_id',$academy->id)->get();
 
            
            if($academy->type==1){
                    $academy->type="Vehicle";
                }else {
                    
                    $academy->type="Motorcycle";
                }
                
                
            foreach($academy->crews as $crew){
                
                $crew->name = User::where('id',$crew->crew_id)->first()->name;
                $crew->title = JobTitle::where('id',$crew->title_id)->first()->name;
               
    
            }
            
         
            //$academy->crew = JobTitle::where();
            
        }
        
        return $this->apiResponse(200 , null , $academies);
     }
     
     
     
        public function courses(Request $request)
     {
        $courses = Course::select('id','name','academy_id','audiance','date','lat','lng','description')->where('user_id',$request->user_id)->get();
        
            foreach($courses as $course){
                
            $academy = Academy::select('id','name','image','category_id','user_id','type')->where('id',$course->academy_id)->first();
            
            
            $sponsers = array();
            $partners = array();
            $audiences = array();
        
        
                if($academy){
                      $academy->image = asset('images/').'/'.$academy->image;
                      $academy->category = Category::select('id','name')->where('id',$academy->category_id)->first();
                }
           
            
            $course_users = CourseUser::where('course_id',$course->id)->get();
            
            foreach($course_users as $course_user){
                
                $user = User::select('id','name')->where('id',$course_user->user_id)->first();
          
              if($course_user->type==1){
                array_push($sponsers,$user);
              }else if($course_user->type==2){
                  array_push($partners,$user);
              }else {
                  array_push($audiences,$user);
              }
            
            }
            
            $course->sponsers = $sponsers;
            $course->partners = $partners;
            $course->audiences = $audiences;
            
            if($academy){
            if($academy->type==1){
              $academy->type="Car Racer";
            }else {
                    $academy->type="Moto Racer";
                }
                
            
            $course->academy = $academy;
                
               }
            }
 
        return $this->apiResponse(200 , null , $courses);
     }
     
     
    public function club_members()
     {
        $clubs = ClubMember::get();
        return $this->apiResponse(200 , null ,ClubMemberResource::collection($clubs));
     }
     
     
    public function save_academy(Request $request)
     {
         $user = auth()->user();
         
         $crew_ids = explode(",",$request->crew_ids) ;
         $crew_title_ids = explode(",",$request->crew_title_ids) ;
         
         
         $image_name="";

      if($request->hasFile('image')){
        $image = $request->file('image');
        $image_name = time() . '-' . $image->getClientOriginalName();
        $image_path = public_path().'/images';
        $image->move($image_path,$image_name);
        }
                 
        $academy = Academy::create([
            'name' => $request->name,
            'type'=> $request->type,
            'image' => $image_name,
            'category_id'=> $request->category_id,
            'user_id'=>$user->id
            ]);
            
         
         $von_text = $user->name." created their academy"; 
         
         VonHistory::create(['user_id' => $user->id , 'text' => $von_text , 'von_id' => $academy->id , 'von_type' => 'new_academy' , 'image'=>$image_name]);
         
         
            if($crew_ids){
        for($i=0; $i<count($crew_ids); $i++){   
            
            
            if($crew_ids[$i]){
                
                
           AcademyCrew::create([
            'academy_id' => $academy->id,
            'crew_id'=> $crew_ids[$i],
            'title_id'=> $crew_title_ids[$i],
            ]);
            
            
            
            $notification_body = 'You were added as one of the academy’s crew';
                
                $notification_title = "Academy Crew";
        
          Notification::create([
                   'title'=>$notification_title,
                   'body'=>$notification_body,
                   'request_id'  => $academy->id,
                   'user_id'=> $crew_ids[$i],
                    'notification_type'=>27
                   ]); 
        
         $tokens = User::whereIn('id',$crew_ids)->pluck('google_id');
         
         $message_complete = array('type'=>"1",'title'=>$notification_title,'body'=>$notification_body);
         
		    $this->send_multi_notification($tokens,$message_complete);
            
            
            
            }
            
        }
            }
            
        return $this->apiResponse(200 , null ,$academy);
     }
     
     
         public function update_academy(Request $request)
     {
         
         $user = auth()->user();
         
         $crew_ids = explode(",",$request->crew_ids) ;
         $crew_title_ids = explode(",",$request->crew_title_ids) ;
         
          $academy = Academy::where('id',$request->academy_id)->first();
   
         
      if($request->hasFile('image')){
        $image = $request->file('image');
        $image_name = time() . '-' . $image->getClientOriginalName();
        $image_path = public_path().'/images';
        $image->move($image_path,$image_name);
         $academy->image = $image_name;
        }
        
        
            $von_text = $user->name." created their academy"; 
            
      VonHistory::create(['user_id' => $user->id , 'text' => $von_text , 'von_id' => $academy->id , 'von_type' => 'update_academy']);
     
                 
            
            $academy->name = $request->name;
            $academy->type = $request->type;
            $academy->category_id = $request->category_id;
        
            
        $academy->save();
        
        
         AcademyCrew::where('academy_id',$academy->id)->delete();
                
         
                 if($crew_ids){
        for($i=0; $i<count($crew_ids); $i++){   
            if($crew_ids[$i]>0)
           AcademyCrew::create([
            'academy_id' => $academy->id,
            'crew_id'=> $crew_ids[$i],
            'title_id'=> $crew_title_ids[$i],
            ]);
            
        }
        
                 }
            
        return $this->apiResponse(200 , "academy updated" ,null);
     }
     
     
     public function save_course(Request $request)
     {
         
         $user = auth()->user();
         
         $sponsor_ids =  $request->sponsor_ids;
         $partners_ids =  $request->partners_ids;
         $crews_ids =  $request->crew_ids;
         
     
         
                 
        $course = Course::create([
            'name' => $request->name,
            'academy_id'=> $request->academy_id,
            'audiance'=> $request->audience,
            'lat'=> $request->lat,
            'lng'=> $request->lng,
            'description'=> $request->description,
            'date'=> $request->date,
            'user_id'=>$user->id
            
            ]);
            
            
       $von_text = $user->name." created a new course";             
            
      VonHistory::create(['user_id' => $user->id , 'text' => $von_text, 'von_id' => $course->id , 'von_type' => 'create_course' ]);
      
            $notification_body = 'You were invited to be the course sponsor ';
            $notification_title = "Course Sponser";
         
        if($sponsor_ids) {
            
            
         for($i=0; $i<count($sponsor_ids); $i++){   
            
           CourseUser::create([
            'course_id' => $course->id,
            'user_id'=> $sponsor_ids[$i],
            'type'=>1
            ]);
            
            Notification::create([
                   'title'=>$notification_title,
                   'body'=>$notification_body,
                   'request_id'  => $course->id,
                   'user_id'=> $sponsor_ids[$i],
                      'notification_type'=>28
                   ]); 

         } 
         
        
        $tokens = User::whereIn('id',$sponsor_ids)->pluck('google_id');
         $message_complete = array('type'=>"1",'title'=>$notification_title,'body'=>$notification_body);
		    $this->send_multi_notification($tokens,$message_complete);
		    
		    
        }
        

		     $notification_body = 'You were invited to be the course partner ';
            $notification_title = "Course partner";
            
            
        if($partners_ids) {
         for($i=0; $i<count($partners_ids); $i++){   
            
           CourseUser::create([
            'course_id' => $course->id,
            'user_id'=> $partners_ids[$i],
            'type'=>2
            ]);
            
             Notification::create([
                   'title'=>$notification_title,
                   'body'=>$notification_body,
                   'request_id'  => $course->id,
                   'user_id'=> $partners_ids[$i],
                      'notification_type'=>29
                   ]); 
                   
        }
        
           $tokens = User::whereIn('id',$partners_ids)->pluck('google_id');
         $message_complete = array('type'=>"1",'title'=>$notification_title,'body'=>$notification_body);
		    $this->send_multi_notification($tokens,$message_complete);
		    
        }
        
        
         $notification_body = 'You were added to be one of the course members';
         $notification_title = "Course member";
            
            
        if($crews_ids) {    
            
         for($i=0; $i<count($crews_ids); $i++){   
            
           CourseUser::create([
            'course_id' => $course->id,
            'user_id'=> $crews_ids[$i],
            'type'=>3
            ]);
            
             Notification::create([
                   'title'=>$notification_title,
                   'body'=>$notification_body,
                   'request_id'  => $course->id,
                   'user_id'=> $crews_ids[$i],
                      'notification_type'=>30
                   ]); 
                   
                   
        }
        
                $tokens = User::whereIn('id',$crews_ids)->pluck('google_id');
         $message_complete = array('type'=>"1",'title'=>$notification_title,'body'=>$notification_body);
		    $this->send_multi_notification($tokens,$message_complete);
		    
        }
            
        return $this->apiResponse(200 , null ,$course);
     }
     
     
      public function update_course(Request $request)
     {
         
         $user = auth()->user();
         
         $sponsor_ids =  $request->sponsor_ids;
         $partners_ids =  $request->partners_ids;
         $crews_ids =  $request->crew_ids;
                 
        $course = Course::where('id',$request->course_id)->first();
        $course->name =  $request->name;
        $course->academy_id =  $request->academy_id;
        $course->audiance =  $request->audience;
        $course->lat =  $request->lat;
        $course->lng =  $request->lng;
        $course->description =  $request->description;
        $course->date =  $request->date;
         
        $course->save();
        
        $von_text = $user->name." updated thier course";  
        
         VonHistory::create(['user_id' => $user->id , 'text' => $von_text , 'von_id' => $course->id , 'von_type' => 'update_course' ]);
        
        
        CourseUser::where('course_id',$request->course_id)->delete();
            
        if($sponsor_ids){
            
        for($i=0; $i<count($sponsor_ids); $i++){   
            
           CourseUser::create([
            'course_id' => $course->id,
            'user_id'=> $sponsor_ids[$i],
            'type'=>1
            ]);
            
        }
        
         }
        
               if($partners_ids){
         for($i=0; $i<count($partners_ids); $i++){   
            
           CourseUser::create([
            'course_id' => $course->id,
            'user_id'=> $partners_ids[$i],
            'type'=>2
            ]);
            
        }
               }
        
        if($crews_ids){
        
         for($i=0; $i<count($crews_ids); $i++){   
            
           CourseUser::create([
            'course_id' => $course->id,
            'user_id'=> $crews_ids[$i],
            'type'=>3
            ]);
            
        }
        }
            
        return $this->apiResponse(200 , null ,$course);
     }
     
     
    public function save_club_member(Request $request)
    {
        $member = ClubMember::create([
            'user_id' => $request->user_id ,
            'club_id' => $request->club_id
            ]);
        return $this->apiResponse(200 , null , new ClubMemberResource($member));
    }
    
    public function update_club(Request $request)
     {
         $club = Club::where('id',$request->club_id)->first();
         
         $club->update([
            'owner_id' => $request->owner_id,
            'president_id'=> $request->president_id,
            'vice_president_id'=> $request->vice_president_id,
            'manager_id'=> $request->manager_id,
            'communication_director_id'=> $request->communication_director_id,
            'assistant_id'=> $request->assistant_id,
            'facilitator_id'=> $request->facilitator_id,
            'marcher_id'=> $request->marcher_id,
            'instructor_id'=> $request->instructor_id,
            'team_leader_id' => $request->team_leader_id,
            ]);
        return $this->apiResponse(200 , null , new ClubResource($club));
     }
     
     
    public function update_club_member(Request $request)
    {
        $member = ClubMember::where('id',$request->club_member_id)->first();

        $member->update([
            'user_id' => $request->user_id ,
            'club_id' => $request->club_id
            ]);
        return $this->apiResponse(200 , null , new ClubMemberResource($member));
    }
    
    
    public function delete_academy(Request $request)
     {
         $academy = Academy::where('id',$request->academy_id)->first();
         $course = Course::where('academy_id',$academy->id)->delete();
         $academy->delete();

         return $this->apiResponse(200 , "academy is deleted" , null);
     }
     
     
        
    public function delete_course(Request $request)
     {
         $course = Course::where('id',$request->course_id)->first();
         
         $course->delete();

         return $this->apiResponse(200 , "course is deleted" , null);
     }
     
     
    public function delete_club_member(Request $request)
    {
        $club = ClubMember::where('id',$request->club_member_id)->first();

        $club->delete();
        
        return $this->apiResponse(200 , "member is deleted" , null);
    }
    
    
        
    function send_multi_notification($tokens,$message_complete ){


    $url = 'https://fcm.googleapis.com/fcm/send';
    $fields = array(
        'registration_ids' => $tokens,
        'notification' => $message_complete
    );

    $headers = array(
        'Authorization:key=AAAAbxLNJ38:APA91bGE9fP5ani91n2BYL8m1HRJHIo_cuupDsvDnvW9EwR56iwfqb7NdtKnonlwAnNvDo9EXL-TnL2080axUwYWAt_wDex7uK9uNZQBM7L6eltT1KwWxOqjK6onYuyR9q0SyWhPjX7W', //Change API KEY HERE
        'Content-Type: application/json'
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt ($ch, CURLOPT_SSL_VERIFYHOST, 0);  
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
    
    $result = curl_exec($ch);  
    
   

    if ($result === FALSE) {
        die('Curl failed: ' . curl_error($ch));
    }
    curl_close($ch);
    
  }
  
}
