<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\CommentResource;
use App\Http\Resources\PostResource;
use App\Models\Comment;
use App\Models\Post;
use App\Models\User;


use Illuminate\Http\Request;

class CommentController extends Controller
{
    public function comments(Request $request)
    {
        $comments =  Post::find($request->post_id)->comments;
        return $this->apiResponse(200,null, CommentResource::collection($comments));
    }


    public function new_comment(Request $request)
    {
        $comment = Comment::create([
         'text' => $request->text,
         'post_id' => $request->post_id,
         'user_id' => auth()->user()->id,
        ]);
        
        
            
         $user_id = Post::where('id',$request->post_id)->first()->user_id;
         
         
         $trip_user = User::select('google_id')->where('id',$user_id)->first();
 
		 $message_complete = array('title'=>"post comment",'body'=>auth()->user()->name." added new comment");
		     
		     
		    $this->send_notification($trip_user->google_id,$message_complete);
		    
		    
		    
        
        return $this->apiResponse(200,'comment is created', new CommentResource($comment));
    }


    public function edit_comment(Request $request)
    {
     $user = auth()->user();
     $comment = Comment::find($request->comment_id);
  if($comment->user_id == $user->id){
     $comment->update(['text' => $request->text ,  $user->id ]);

         return $this->apiResponse(200,'comment is updated', new CommentResource($comment));
     }
         return $this->apiResponse(200, 'you cant edit this comment', new CommentResource($comment));
    }


    public function delete_comment(Request $request)
    {
        $comment = Comment::findOrFail($request->comment_id);
        if($comment->user_id == auth()->user()->id){
         $comment->delete();
         return $this->apiResponse(200,'comment is deleted', new CommentResource($comment));
        }
        return $this->apiResponse(401,'you cant delete this comment', new CommentResource($comment));

    }
    
    
    function send_notification($token,$message_complete ){
      
      
    $tokens = array();
     
   
    
    array_push($tokens,$token);
    
 
    
    
    $url = 'https://fcm.googleapis.com/fcm/send';
    $fields = array(
        'registration_ids' => $tokens,
        'notification' => $message_complete
    );

    $headers = array(
        'Authorization:key=AAAAbxLNJ38:APA91bGE9fP5ani91n2BYL8m1HRJHIo_cuupDsvDnvW9EwR56iwfqb7NdtKnonlwAnNvDo9EXL-TnL2080axUwYWAt_wDex7uK9uNZQBM7L6eltT1KwWxOqjK6onYuyR9q0SyWhPjX7W', //Change API KEY HERE
        'Content-Type: application/json'
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt ($ch, CURLOPT_SSL_VERIFYHOST, 0);  
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
    
    $result = curl_exec($ch);  
    
   

    if ($result === FALSE) {
        die('Curl failed: ' . curl_error($ch));
    }
    curl_close($ch);
    
  }
  
}
