<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\PostResource;
use App\Models\Image;
use App\Models\Post;
use App\Models\User;
use App\Models\VonHistory;
use Illuminate\Http\Request;
use App\Models\Car;
use App\Models\Story;
use App\Models\Team;
use App\Models\Venue;
use App\Models\Club;
use App\Models\Career;
use App\Models\Champion;
use App\Models\Event;
use App\Models\Comment;
use App\Models\Like;
use App\Models\SavedPost;
use App\Models\Notification;


class PostController extends Controller
{
   public function get_posts()
   {
        $user = auth()->user();
        $posts = Post::latest()->paginate(20);

        foreach($posts as $post){
        $post->added_at = $post->created_at->diffForHumans();
        $images = Image::where('post_id',$post->id)->get();
        $post->is_liked = $user->likes->contains($post->id);
        $post->comments_count = Comment::where('post_id',$post->id)->count();
        
        $post->comment = Comment::where('post_id',$post->id)->latest()->first();
        
        if($post->comment){
            $post->comment = User::where('id',$post->user_id)->first()->name." : ".$post->comment->text;
        }
        
        $post->likes_count = Like::where('post_id',$post->id)->count();
        $post['images'] =  $images;
          $post->is_saved = SavedPost::where('post_id',$post->id)->first()?true:false; 
        }
        
      

        $results = PostResource::collection($posts);
        return $this->apiResponse(200,null, $results);
   }
   
   
   public function get_stories(){
       
       $user = auth()->user();
       
       $user_stories = array();
        
       $users = User::select('id','name','image','type')->whereIn('id',Story::select('user_id')->get()->pluck('user_id'))->get();
    
 
       
       foreach($users as $user){
           
           $user->image = asset('images/').'/'.$user->image;
           
           $story_temp = Story::select('id','user_id','media','type')->where('user_id',$user->id)->get();
           
          
           foreach($story_temp as $story){
               
               $story->media = asset('images/').'/'.$story->media;
           }
           
          $user->stories = $story_temp;
       }
       
       
        foreach($users as $user_temp){
            
            if($user->id == $user_temp->id){
            array_push($user_stories,$user_temp);
            }
        }
       
       foreach($users as $user_temp){
            
            if($user->id != $user_temp->id){
            array_push($user_stories,$user_temp);
            }
        }
       
       return $this->apiResponse(200,null, $user_stories);
   }
   
   
   
   
     
   public function add_story(Request $request)
   {
       
       if(!$request->type)$request->type=0;
     
      if($request->hasFile('media')){
        $media = $request->file('media');
        $file_name = Time().'-'.$media->getClientOriginalName();
        $file_path = public_path().'/images';
        $media->move($file_path,$file_name);
       }
    
       $post = Story::create([
        'media' => $file_name,
         'type' => $request->type,
        'user_id' => auth()->user()->id,
       ]);
       return $this->apiResponse(200,null, $post);
   }
 
 
   public function get_posts_by_type(Request $request)
   {
       $user = auth()->user();
       
       
       $posts = Post::where('media_type',$request->media_type)->latest()->paginate(20);

       foreach($posts as $post){
        $post->added_at = $post->created_at->diffForHumans();
        $images = Image::where('post_id',$post->id)->get();
        $post->is_liked = $user->likes->contains($post->id);
        $post['images'] =  $images;
        $post->is_saved = SavedPost::where('post_id',$post->id)->first()?true:false; 
        }

        // return   $posts;
        $results = PostResource::collection($posts);

        // $results['images'] =

       return $this->apiResponse(200,null, $results);
   }
   
   
   public function get_posts_by_users(Request $request)
   {
                $user = auth()->user();
                $posts = Post::latest()->paginate(20);
             if($request->type=="me"){
                $posts = Post::where('user_id',$user->id)->latest()->paginate(20);
       }else if($request->type=="friends"){
                $posts = Post::whereIn('user_id',$user->following->pluck('id'))->latest()->paginate(20);
       }else {
                $posts = Post::latest()->paginate(20);
       }

        foreach($posts as $post){
        $post->added_at = $post->created_at->diffForHumans();
        $images = Image::where('post_id',$post->id)->get();
        $post->is_liked = $user->likes->contains($post->id);
        $post->is_saved = SavedPost::where('post_id',$post->id)->first()?true:false; 
       
       
        $post['images'] =  $images;
        }

        // return   $posts;
        $results = PostResource::collection($posts);

        // $results['images'] =

       return $this->apiResponse(200,null, $results);
   }


   public function show_post(Request $request)
   {
       
    $user = auth()->user();
       $post = Post::find($request->post_id);
       $post->is_liked = $user->likes->contains($post->id);
       
        
        $post->added_at = $post->created_at->diffForHumans();
        $images = Image::where('post_id',$post->id)->get();
        $post->is_liked = $user->likes->contains($post->id);
        $post['images'] =  $images;
   
        

       return $this->apiResponse(200,null, new PostResource($post));
   }


   public function new_post(Request $request)
   {
       
       if($request->youtube){
           
           
         $post = Post::create([
        'text' => $request->text,
        'media_type' => $request->media_type,
        'youtube' => $request->youtube,
        'privacy' => $request->privacy,
        'user_id' => auth()->user()->id,
       ]);
           
       }else {
       
    if($request->hasFile('media')){

        $media = $request->file('media');
        $file_name = Time().'-'.$media->getClientOriginalName();
        $file_path = public_path().'/images';
        $media->move($file_path,$file_name);
    }
       $post = Post::create([
        'text' => $request->text,
        'media_type' => $request->media_type,
        'media' => $file_name ?? null,
        'privacy' => $request->privacy,
        'user_id' => auth()->user()->id,
       ]);

       if($request->hasFile('images')){

        foreach ($request->file('images') as $image) {
            $file_name = rand(1111111111, 9999999999).'-'.$image->getClientOriginalName();
            $file_path = public_path().'/images';
            $image->move($file_path,$file_name);
            $new_image = Image::create(['name'=>$file_name , 'post_id' =>  $post->id]);
        }
    }
       }
       return $this->apiResponse(200,'post is created', new PostResource($post));
   }


   public function edit_post(Request $request)
   {
    $user = auth()->user();
    $post = Post::find($request->post_id);

    if($post->user_id == $user->id){

        if($request->hasFile('media')){

            $media = $request->file('media');
            $file_name = Time().'-'.$media->getClientOriginalName();
            $file_path = public_path().'/media';
            $media->move($file_path,$file_name);
        }

        $post->update([
            'text' => $request->text,
            'media_type' => $request->media_type,
            'media' => $file_name ?? null,
            'privacy' => $request->privacy,
        ]);

        if($request->hasFile('images')){

            foreach ($request->file('images') as $image) {
                $file_name = Time().'-'.$image->getClientOriginalName();
                $file_path = public_path().'/images';
                $image->move($file_path,$file_name);
                $new_image = Image::create(['name'=>$file_name , 'post_id' => $post->id ]);
            }
        }
        return $this->apiResponse(200,'post is updated', new PostResource($post));
    }
        return $this->apiResponse(200, 'you cant edit this post', new PostResource($post));
   }
   
   
   public function edit_post_text(Request $request)
   {
    $user = auth()->user();
    $post = Post::find($request->post_id);


        $post->update([
            'text' => $request->text,
        ]);
 
    return $this->apiResponse(200, 'post edited', null);
   }


   public function delete_post(Request $request)
   {
       $post = Post::find($request->post_id);
       if($post){
        $post->delete();
        return $this->apiResponse(200,'post is deleted', new PostResource($post));
       }
   }
   
   
    public function report(Request $request)
   {
       $post = Post::find($request->post_id);
        
        return $this->apiResponse(200,'post is reported', new PostResource($post ));
    
   }
   
   
   public function turn_of_comments(Request $request)
   {
       $post = Post::find($request->post_id);
       
       if($post){
         
         if($post->turn_off_comment==0){
             $post->turn_off_comment=1;  
         }
         else {
             $post->turn_off_comment=0;
         }


        $post->save();
        
        return $this->apiResponse(200,'post comment off', new PostResource($post));
       }
   }
   
   
   public function save_post(Request $request)
   {

         $user = auth()->user();
         
       $post = SavedPost::where('post_id',$request->post_id)->first();
       
       if($post){
           
           $post->delete();
           
       }else {

        $post = SavedPost::create([
                 'post_id' => $request->post_id
              ,'user_id' => $user->id
             ]);  
       
       }
      
        return $this->apiResponse(200,'post is created', $post);
 
   }


   public function show_vons()
    {
             $user = auth()->user();
             
             
            $vons = VonHistory::select('user_id','text','von_type','von_id','created_at')->latest()->paginate(1000);
    
    
     foreach($vons as $von){
        
            $von->added_at = $von->created_at->diffForHumans();
            $von->user = User::select('id','name','image','type')->where('id',$von->user_id)->first();
            
            if($von->user){
            $von->user->image =  asset('images/').'/'. $von->user->image ;
             $von->user->background_image =  asset('images/').'/'. $von->user->background_image ;
           
            $von->user->is_follow = $user->following->contains($von->user_id);
            }
            
            $added_image="";
            
            
            
         if($von->von_type=="create_car" || $von->von_type=="update_car"){
            $car = Car::where('id',$von->von_id)->first();
            if($car){
            $added_image = $car->image;
            }
         }else if($von->von_type=="create_team" || $von->von_type=="update_team"){
            $team = Team::where('id',$von->von_id)->first();
            if($team){
            $added_image = $team->image;
            }
         }else if($von->von_type=="create_venue" || $von->von_type=="update_venue"){
            $venue = Venue::where('id',$von->von_id)->first();
            if($venue){
            $added_image = $venue->image;
            }
         }else if($von->von_type=="club_created" || $von->von_type=="club_updated"){
            $club = Club::where('id',$von->von_id)->first();
            if($club){
            $added_image = $club->image;
            }
         }else if($von->von_type=="career_created" || $von->von_type=="career_updated"){
            $career = Career::where('id',$von->von_id)->first();
            if($career){
            $added_image = $career->image;
            }
         }else if($von->von_type=="champion_created" || $von->von_type=="champion_updated"){
            $champion = Champion::where('id',$von->von_id)->first();
            if($champion){
            $added_image = $champion->image;
            }
         } else if($von->von_type=="champion_event_created" || $von->von_type=="champion_event_updated"){
            $event = Event::where('id',$von->von_id)->first();
            if($event){
            $added_image = $event->image;
            }
         } 
         
         
          if($added_image){
            $von->image = asset('images/').'/'.$added_image ;
            }
    }
    
     return $this->apiResponse(200,null, $vons);

   }


   public function post_like(Request $request)
    {
        $user = auth()->user();
        if($user->likes->contains($request->post_id)){
            
            $user->likes()->detach($request->post_id);
            
            $user_id = Post::where('id',$request->post_id)->first()->user_id;
            $trip_user = User::select('google_id')->where('id',$user_id)->first();
 
		     $message_complete = array('title'=>"post like",'body'=>$user->name." liked your post");
		    //$this->send_notification($trip_user->google_id,$message_complete);
            
            return $this->apiResponse(200, null, new PostResource(Post::find($request->post_id)));
        }
        else {
            
            
            
            
             $user_id = Post::where('id',$request->post_id)->first()->user_id;
            $trip_user = User::select('google_id')->where('id',$user_id)->first();
 
		     $message_complete = array('title'=>"post like",'body'=>$user->name." liked your post");
		    $this->send_notification($trip_user->google_id,$message_complete);
		    
		    
		     $notification_title = "Post like";
         
        $notification_body = $user->name." liked your post";
        
         $tokens = User::where('id',$user_id)->pluck('google_id');
         
         Notification::create([
                   'title'=>$notification_title,
                   'body'=>$notification_body,
                   'request_id'  => 0,
                   'user_id'=> $user_id,
                   'notification_type'=>0
                   ]);
            
            
         $user->likes()->attach($request->post_id);
            
            return $this->apiResponse(200,null, new PostResource(Post::find($request->post_id)));
        }
    }

   public function post_by_user(Request $request)
    {
        $posts = Post::where('user_id',$request->user_id)->get();
        return $this->apiResponse(200, null,  PostResource::collection($posts));
    }

     public function saved_posts(Request $request)
    {
        $user = auth()->user();
        $posts = Post::whereIn('id',SavedPost::select('post_id')->where('user_id',$user->id)->get()->pluck('post_id'))->get();
        return $this->apiResponse(200, null,  PostResource::collection($posts));
    }
    
    
    
    function send_notification($token,$message_complete ){
      
      
    $tokens = array();
     
   
    
    array_push($tokens,$token);
    
 
    
    
    $url = 'https://fcm.googleapis.com/fcm/send';
    $fields = array(
        'registration_ids' => $tokens,
        'notification' => $message_complete
    );

    $headers = array(
        'Authorization:key=AAAAbxLNJ38:APA91bGE9fP5ani91n2BYL8m1HRJHIo_cuupDsvDnvW9EwR56iwfqb7NdtKnonlwAnNvDo9EXL-TnL2080axUwYWAt_wDex7uK9uNZQBM7L6eltT1KwWxOqjK6onYuyR9q0SyWhPjX7W', //Change API KEY HERE
        'Content-Type: application/json'
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt ($ch, CURLOPT_SSL_VERIFYHOST, 0);  
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
    
    $result = curl_exec($ch);  
    
   

    if ($result === FALSE) {
        die('Curl failed: ' . curl_error($ch));
    }
    curl_close($ch);
    
  }
  



}
