<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Champion;
use App\Models\Category;
use App\Models\User;
use App\Models\ChampionCrew;
use App\Models\Job;
use App\Models\JobTitle;
use App\Models\Course;
use App\Models\CourseUser;
use App\Models\Event;
use App\Models\EventCrew;
use App\Models\VenueMember;
use App\Models\Venue;
use App\Models\VenueEvent;
use App\Models\VenueEventMember;
use App\Models\Team;
use App\Models\TeamMember;
use App\Models\VonHistory;
use App\Models\TeamParticipation;
use App\Models\TeamParticipationMember;
use App\Http\Resources\UserResource;
use App\Models\Notification;



class TeamController extends Controller
{
    
    public function team_members(Request $request)
    {
        $team = Team::where('id',$request->team_id)->first();
        if($team){
             $members =  $team->members;
             return $this->apiResponse(200 , null ,UserResource::collection($members));
        }
             return $this->apiResponse(404 , 'team not found' ,null);

       

    }
    
    public function teams(Request $request)
     {
        $venues = Team::select('id','user_id','name','type','category_id','lat','lng','owner_id','image')->where('user_id',$request->user_id)->get();
        
        foreach($venues as $venue){
            
          $sponsers = array();
          $partners = array();
          $crews = array();
          $drivers = array();
            
          $venue->image != "" ? $venue->image = asset('images/').'/'.$venue->image : $venue->image = null;
          $venue->category = Category::select('id','name')->where('id',$venue->category_id)->first();
          $venue_members = TeamMember::select('id','member_id','title_id','type','start_date','end_date')->where('team_id',$venue->id)->get();
          $venue->owner = User::where('id',$venue->owner_id)->first()->name;
            
       if($venue->type==0){
          $venue->type="Vehicle";
                }else {
          $venue->type="Motorcycle";
        }
                
                
        foreach($venue_members as $venue_member){
                
        $user = User::select('id','name')->where('id',$venue_member->member_id)->first();
        
         if($user){
             
               if($venue_member->type==3){
                   $user->title=JobTitle::select('id','name')->where('id',$venue_member->title_id)->first();
                   
                   if($user->title){
                       $user->title_id = $user->title->id;
                       $user->title = $user->title->name;
                       
                   }
                   
                    array_push($crews,$user);
               }else if($venue_member->type==1){
                   array_push($sponsers,$user);
                }else if($venue_member->type==2){
                   array_push($partners,$user);
                }
                else if($venue_member->type==4) {
                    $user->start_date = $venue_member->start_date;
                    $user->end_date = $venue_member->end_date;
                array_push($drivers,$user);
                  }
            }
            }
            
         
            
            $venue->crews = $crews;
            $venue->sponsers = $sponsers;
            $venue->partners = $partners;
            $venue->drivers = $drivers;
            
        }
        
        return $this->apiResponse(200 , null , $venues);
     }
     
     
     
  public function save_team(Request $request)
      
   {
         
        $user = auth()->user();
     
        $crews_title_ids = explode(",",$request->crews_title_ids) ;
        $crews_ids = explode(",",$request->crew_ids) ;
        $sponsor_ids = explode(",",$request->sponsor_ids) ;
        $partners_ids = explode(",",$request->partners_ids) ;
        $driver_ids = explode(",",$request->driver_ids);
        $driver_start_dates = explode(",",$request->driver_start_dates);
        $driver_end_dates = explode(",",$request->driver_end_dates);
          
        $image_name="";
     if($request->hasFile('image')){
        $image = $request->file('image');
        $image_name = time() . '-' . $image->getClientOriginalName();
        $image_path = public_path().'/images';
        $image->move($image_path,$image_name);
        }
         
                 
        $event = Team::create([
            'name' => $request->name,
            'category_id'=> $request->category,
            'type'=> $request->type,
            'lat'=> $request->lat,
            'lng'=> $request->lng,
            'owner_id'=> $request->owner,
            'user_id'=>$user->id,
            'image'=>$image_name
        ]);
            
            
            Notification::create([
                   'title'=>$request->name,
                   'body'=>'You were invited a team owner',
                   'request_id'  => $event->id,
                   'user_id'=> $request->owner,
                      'notification_type'=>21
                   ]); 
        
         $tokens = User::where('id',$request->owner)->pluck('google_id');
         $message_complete = array('type'=>"1",'title'=>$request->name,'body'=>$user->name.' has added you as a team owner');
		    $this->send_multi_notification($tokens,$message_complete);
	
        
        $von_text = $user->name." added his team";
            
        VonHistory::create(['user_id' => $user->id , 'text' => $von_text, 'von_id' => $event->id , 'von_type' => 'create_team']);
        
        

    for($i=0; $i<count($sponsor_ids); $i++){   
                  if($sponsor_ids[$i]){
                      
                      
              TeamMember::create([
                  'team_id'  => $event->id,
                      'member_id'=> $sponsor_ids[$i],
                      'type'=>1
                   ]);
                   
                   
                Notification::create([
                   'title'=>$request->name,
                   'body'=>'You were invited a team sponsor',
                   'request_id'  => $event->id,
                   'user_id'=> $sponsor_ids[$i],
                      'notification_type'=>22
                   ]); 
                   
                   
                 }
        }
        
        
        $tokens = User::whereIn('id',$sponsor_ids)->pluck('google_id');
         $message_complete = array('type'=>"1",'title'=>$request->name,'body'=>'You were invited a team sponsor');
		    $this->send_multi_notification($tokens,$message_complete);
        
        
        
        
    for($i=0; $i<count($partners_ids); $i++){   
     if($partners_ids[$i]){
        TeamMember::create([
            'team_id' => $event->id,
            'member_id'=> $partners_ids[$i],
            'type'=>2
        ]);
                
                
                Notification::create([
                   'title'=>$request->name,
                   'body'=>'You were invited a team partner',
                   'request_id'  => $event->id,
                   'user_id'=> $partners_ids[$i],
                      'notification_type'=>23
                   ]); 
                   
        
        
                }
        }
        
        
         $tokens = User::whereIn('id',$partners_ids)->pluck('google_id');
         $message_complete = array('type'=>"1",'title'=>$request->name,'body'=>'You were invited a team partner');
		    $this->send_multi_notification($tokens,$message_complete);
        
        
    
        
        
     if($crews_ids){
    for($i=0; $i<count($crews_ids); $i++){  
        
     if($crews_ids[$i]&&$crews_title_ids[$i]){
         
 
        TeamMember::create([
            'team_id' => $event->id,
            'member_id'=> $crews_ids[$i],
            'title_id'=> $crews_title_ids[$i],
            'type'=>3
            ]);
            
          
            Notification::create([
                   'title'=>$request->name,
                   'body'=>'You were invited a team crew',
                   'request_id'  => $event->id,
                   'user_id'=> $crews_ids[$i],
                      'notification_type'=>24
                   ]);  
          
            
            
        }
 }
        
         $tokens = User::whereIn('id',$crews_ids)->pluck('google_id');
         $message_complete = array('type'=>"1",'title'=>$request->name,'body'=>'You were invited a team crew');
		    $this->send_multi_notification($tokens,$message_complete);
        
        
        }
          
     if($driver_ids){
    for($i=0; $i<count($driver_ids); $i++){   
     if($driver_ids[$i]){
         
         
         
        TeamMember::create([
            'team_id' => $event->id,
            'member_id'=> $driver_ids[$i],
            'start_date'=> $driver_start_dates[$i],
            'end_date'=> $driver_end_dates[$i],
            'type'=>4
        ]);
        
        
          
            Notification::create([
                   'title'=>$request->name,
                   'body'=>$user->name.' has added you as a team driver',
                   'request_id'  => $event->id,
                   'user_id'=> $crews_ids[$i],
                      'notification_type'=>25
                   ]);
                   
        
        }
        
        
        
        
         $tokens = User::whereIn('id',$driver_ids)->pluck('google_id');
         $message_complete = array('type'=>"1",'title'=>$request->name,'body'=>$user->name.' has added you as a team driver');
		    $this->send_multi_notification($tokens,$message_complete);
        
        
        }
        
        
        }
        return $this->apiResponse(200 , null ,$event);
     }
     
     
     
   public function update_team(Request $request)
      
   {
         
         $user = auth()->user();
         
     
          $crews_title_ids = explode(",",$request->crew_title_ids) ;
          $crews_ids = explode(",",$request->crew_ids) ;
          $sponsor_ids = explode(",",$request->sponsor_ids) ;
          $partners_ids = explode(",",$request->partners_ids) ;
          
          $driver_ids = explode(",",$request->driver_ids);
          
          $driver_start_dates = explode(",",$request->driver_start_dates);
          $driver_end_dates = explode(",",$request->driver_end_dates);
          
          $image_name="";
             
         $team = Team::where('id',$request->team_id)->first();
                     
      if($request->hasFile('image')){
        $image = $request->file('image');
        $image_name = time() . '-' . $image->getClientOriginalName();
        $image_path = public_path().'/images';
        $image->move($image_path,$image_name);
         $team->image = $image_name;
        }
         
                 

        
        
        
        $team->name = $request->name;
        $team->category_id = $request->category;
        $team->type = $request->type;
        $team->lat = $request->lat;
        $team->lng = $request->lng;
        $team->owner_id = $request->owner;
        
        
       $event = $team;
       
       
       $von_text = $user->name." updated his team";
            
             VonHistory::create(['user_id' => $user->id , 'text' => $von_text, 'von_id' => $event->id , 'von_type' => 'update_team' ]);
            
            $team->save();
        
        TeamMember::where('team_id',$team->id)->delete();
         
            
 for($i=0; $i<count($sponsor_ids); $i++){   
                 if($sponsor_ids[$i])
           TeamMember::create([
            'team_id' => $event->id,
            'member_id'=> $sponsor_ids[$i],
            'type'=>1
            ]);
            
        }
        
         for($i=0; $i<count($partners_ids); $i++){   
             if($partners_ids[$i])
           TeamMember::create([
            'team_id' => $event->id,
            'member_id'=> $partners_ids[$i],
            'type'=>2
            ]);
            
        }
        
        if($crews_ids){
        
         for($i=0; $i<count($crews_ids); $i++){   
            if($crews_ids[$i]&&$crews_title_ids[$i])
           TeamMember::create([
            'team_id' => $event->id,
            'member_id'=> $crews_ids[$i],
            'title_id'=> $crews_title_ids[$i],
            'type'=>3
            ]);
            
        }
        }
          
        if($driver_ids){
        
         for($i=0; $i<count($driver_ids); $i++){   
            if($driver_ids[$i]){
          TeamMember::create([
            'team_id' => $event->id,
            'member_id'=> $driver_ids[$i],
            'start_date'=> $driver_start_dates[$i],
             'end_date'=> $driver_end_dates[$i],
            'type'=>4
            ]);
            }
        }
        }
            
        return $this->apiResponse(200 , null ,$team);
     }
     
     
     
     public function delete_team(Request $request)
     {
         $team = Team::where('id',$request->team_id)->first();
         
         $team->delete();

         return $this->apiResponse(200 , "team is deleted" , null);
     }
     
     
     public function venue_events(Request $request)
     {
         
        $venue_events = VenueEvent::select('id','is_my_event','type','image','name','category_id','user_id','date','description','best_record_user_id','best_record_hours','best_record_minutes','best_record_seconds')->where('user_id',$request->user_id)->get();
        
            $sponsers = array();
            $partners = array();
            $racers = array();
        
        foreach($venue_events as $venue_event){
            $venue_event->image = asset('images/').'/'.$venue_event->image;
            $venue_event->category = Category::select('id','name')->where('id',$venue_event->category_id)->first();
            $event_users = VenueEventMember::select('id','member_id','type')->where('venue_event_id',$venue_event->id)->get();
            
            $venue_event->best_record =  User::select('id','name')->where('id',$venue_event->best_record_user_id)->first();
            
            if($venue_event->best_record){
                $venue_event->best_record = $venue_event->best_record->name;
            }
             
            
            if($venue_event->type==1){
                    $venue_event->type="Car Racer";
                }else {
                    $venue_event->type="Moto Racer";
                }
                
                foreach($event_users as $event_user){
                
                $user = User::select('id','name')->where('id',$event_user->member_id)->first();
                
                 if($user){
                     
                       if($event_user->type==1){
                     array_push($sponsers,$user);
                       }else if($event_user->type==2){
                          array_push($partners,$user);
                          }else {
                         array_push($racers,$user);
                          }
            
                    }
                 }
           $venue_event->sponsers = $sponsers;
           $venue_event->partners = $partners;
           $venue_event->racers = $racers;
           
            
        }
        
        return $this->apiResponse(200 , null , $venue_events);
     }
     
     
         
  public function save_team_participation(Request $request)
  {
      
         $user = auth()->user();
              
           
          $crews_ids = explode(",",$request->driver_ids);
           $image_name="";
             
      if($request->hasFile('image')){
        $image = $request->file('image');
        $image_name = time() . '-' . $image->getClientOriginalName();
        $image_path = public_path().'/images';
        $image->move($image_path,$image_name);
        }
         
                 
        $event = TeamParticipation::create([
            'champions' => $request->champions,
            'event_id' => $request->event_id,
            'team_rank' => $request->team_rank,
            'user_id'=>$user->id,
            'image'=>$image_name
            ]);
            
        
        if($crews_ids){
        
         for($i=0; $i<count($crews_ids); $i++){   
             
           TeamParticipationMember::create([
            'team_participations_id' => $event->id,
            'member_id'=> $crews_ids[$i],
            'type'=>1
            ]);
            
        }
        
        $notification_body = 'You added as a team participation in event '.Event::where('id',$request->event_id)->first()->name;
        
          Notification::create([
                   'title'=>"Participation in team",
                   'body'=>$notification_body,
                   'request_id'  => $event->id,
                   'user_id'=> $crews_ids[$i],
                      'notification_type'=>26
                   ]); 
        
         $tokens = User::whereIn('id',$crews_ids)->pluck('google_id');
         
         $message_complete = array('type'=>"1",'title'=>"Participation in team",'body'=>$notification_body);
         
		    $this->send_multi_notification($tokens,$message_complete);
		    
        
        
        }
        
        
          $von_text = $user->name." added their team participation";
        
        VonHistory::create(['user_id' => $user->id , 'text' => $von_text, 'von_id' => $event->id , 'von_type' => 'create_participation' ]);
        
        
        return $this->apiResponse(200 , null ,$event);
        
     }
     
     
     public function delete_team_participation(Request $request)
     {
         $team_participation = TeamParticipation::where('id',$request->team_participation_id)->first();
         $team_participation->delete();
         
         return $this->apiResponse(200 , 'team participation is deleted' , null);
         
     }
     
     
     
     
     
      public function update_team_participation(Request $request)
  {
      
         $user = auth()->user();
              
           
          $crews_ids = explode(",",$request->driver_ids);
           $image_name="";
           
           $event = TeamParticipation::where('id',$request->team_participation_id)->first();
           $event->champions = $request->champions;
           $event->event_id = $request->event_id;
           $event->team_rank = $request->team_rank;
           
           
           $von_text = $user->name." updated their team participation";
  
            VonHistory::create(['user_id' => $user->id , 'text' => $von_text , 'von_id' => $event->id , 'von_type' => 'updated_participation' ]);
           
             
      if($request->hasFile('image')){
        $image = $request->file('image');
        $image_name = time() . '-' . $image->getClientOriginalName();
        $image_path = public_path().'/images';
        $image->move($image_path,$image_name);
        $event->image = $image_name;
        }
         
 
    TeamParticipationMember::where('team_participations_id',$request->team_participation_id)->delete();
            
        
        if($crews_ids){
        
         for($i=0; $i<count($crews_ids); $i++){   
             
           TeamParticipationMember::create([
            'team_participations_id' => $event->id,
            'member_id'=> $crews_ids[$i],
            'type'=>1
            ]);
            
        }
        }
        
        $event->save();
        
        return $this->apiResponse(200 , null ,$event);
        
     }
     
     
   
     
     public function team_participations(Request $request)
     {
         
           $venues = TeamParticipation::select('id','user_id','champions','event_id','team_rank')->where('user_id',$request->user_id)->get();
        
          
          $drivers = array();
        
        foreach($venues as $venue){
            
            $venue->event = Event::select('id','name')->where('id',$venue->event_id)->first();
            $venue_members = TeamParticipationMember::select('id','member_id')->where('team_participations_id',$venue->id)->get();
            
            foreach($venue_members as $venue_member){
                
                $user = User::select('id','name')->where('id',$venue_member->member_id)->first();
                
                 if($user){
                     array_push($drivers,$user);
                    }
            }
            
        
            $venue->drivers = $drivers;
            
        }
        
        return $this->apiResponse(200 , null , $venues);
     }
     
     
    public function club_members()
     {
        $clubs = ClubMember::get();
        return $this->apiResponse(200 , null ,ClubMemberResource::collection($clubs));
     }
     
     
    public function save_club(Request $request)
     {
        $club = Club::create([
            'owner_id' => $request->owner_id,
            'president_id'=> $request->president_id,
            'vice_president_id'=> $request->vice_president_id,
            'manager_id'=> $request->manager_id,
            'communication_director_id'=> $request->communication_director_id,
            'assistant_id'=> $request->assistant_id,
            'facilitator_id'=> $request->facilitator_id,
            'marcher_id'=> $request->marcher_id,
            'instructor_id'=> $request->instructor_id,
            'team_leader_id' => $request->team_leader_id,
            ]);
        return $this->apiResponse(200 , null , new ClubResource($club));
     }
     
     
    public function save_club_member(Request $request)
    {
        $member = ClubMember::create([
            'user_id' => $request->user_id ,
            'club_id' => $request->club_id
            ]);
        return $this->apiResponse(200 , null , new ClubMemberResource($member));
    }
    
    public function update_club(Request $request)
     {
         $club = Club::where('id',$request->club_id)->first();
         
         $club->update([
            'owner_id' => $request->owner_id,
            'president_id'=> $request->president_id,
            'vice_president_id'=> $request->vice_president_id,
            'manager_id'=> $request->manager_id,
            'communication_director_id'=> $request->communication_director_id,
            'assistant_id'=> $request->assistant_id,
            'facilitator_id'=> $request->facilitator_id,
            'marcher_id'=> $request->marcher_id,
            'instructor_id'=> $request->instructor_id,
            'team_leader_id' => $request->team_leader_id,
            ]);
        return $this->apiResponse(200 , null , new ClubResource($club));
     }
     
     
    public function update_club_member(Request $request)
    {
        $member = ClubMember::where('id',$request->club_member_id)->first();

        $member->update([
            'user_id' => $request->user_id ,
            'club_id' => $request->club_id
            ]);
        return $this->apiResponse(200 , null , new ClubMemberResource($member));
    }
    
    public function delete_club_member(Request $request)
    {
        $club = ClubMember::where('id',$request->club_member_id)->first();

        $club->delete();
        
        return $this->apiResponse(200 , "member is deleted" , null);
    }
    
    
    function send_multi_notification($tokens,$message_complete ){


    $url = 'https://fcm.googleapis.com/fcm/send';
    $fields = array(
        'registration_ids' => $tokens,
        'notification' => $message_complete
    );

    $headers = array(
        'Authorization:key=AAAAbxLNJ38:APA91bGE9fP5ani91n2BYL8m1HRJHIo_cuupDsvDnvW9EwR56iwfqb7NdtKnonlwAnNvDo9EXL-TnL2080axUwYWAt_wDex7uK9uNZQBM7L6eltT1KwWxOqjK6onYuyR9q0SyWhPjX7W', //Change API KEY HERE
        'Content-Type: application/json'
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt ($ch, CURLOPT_SSL_VERIFYHOST, 0);  
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
    
    $result = curl_exec($ch);  
    
   

    if ($result === FALSE) {
        die('Curl failed: ' . curl_error($ch));
    }
    curl_close($ch);
    
  }
  
}
