<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class CareerResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
    return [
        'id' => $this->id,
        'type' => $this->type,
        'privacy' => $this->privacy,
        'event_name' => $this->event_name,
        'long' => $this->long,
        'lat' => $this->lat,
        'end_lat' => strval($this->end_lat),
        'end_lng' => strval($this->end_lng),
        'date' => $this->date,
        'description' => $this->description,
        'image' => $this->image != null ? asset('images/').'/'. $this->image : null,
        'members' => $this->members,
    ];
    }
}
