<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class CommentResource extends JsonResource
{
    public function toArray($request)
    {
        return [
          'id' => $this->id,
          'text' => $this->text,
          'post' => $this->post->text,
          'user_id' => $this->user->id,
          'user' => $this->user->name,
          'user_image' => $this->user->image != null ? asset('images/').'/'. $this->user->image : null,
          'created_at' => '10 mins ago',
        ];
    }
}

