<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Champion extends Model
{
    use HasFactory , SoftDeletes;

    protected $fillable = ['id','type','category_id','image','name','user_id'];


    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }


    public function crews()
    {
        return $this->hasMany(AcademyCrew::class, 'academy_id', 'id');
    }
}
