<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Event extends Model
{
    use HasFactory , SoftDeletes;

    protected $fillable = ['name','turns_number','champion_id','race_capacity','audience_capacity','details','image', 'date' ,'status','user_id','street_race_venue','lat','long','shampionship_id','best_record_user_id','racer_capicity','audience_capicity','length','turns_no','description','sponsor_id','partner_id','best_record_hours','best_record_minutes','best_record_seconds','venue_user_id','type','user_rank'];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }
    public function sponsor()
    {
        return $this->belongsTo(User::class, 'sponsor_id', 'id');
    }
    public function partner()
    {
        return $this->belongsTo(User::class, 'partner_id', 'id');
    }
}
