<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Team extends Model
{
    use HasFactory , SoftDeletes;

    protected $fillable = ['user_id','name','type','category_id','lat','lng','owner_id','image','created_at','updated_at','deleted_at'];
    
    protected $casts = ['lat' => 'decimal:8' , 'lng' => 'decimal:8'];
    
    
    public function members()
    {
        return $this->belongsToMany(User::class , 'team_members','team_id','member_id');
    }


 
}
