<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TeamMember extends Model
{
    use HasFactory, SoftDeletes;
    
    protected $fillable = ['member_id','title_id','team_id','type','start_date','end_date','created_at','updated_at','deleted_at'];
    
    public function user()
    {
        return $this->belongsTo(User::class, 'member_id', 'id');
    }
    
    
  
}
