<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Venue extends Model
{
    use HasFactory , SoftDeletes;

    protected $fillable = ['turns_number','race_capacity','audience_capacity','details','image', 'date' ,'status','user_id','street_race_venue','lat','lng','shampionship_id','best_record_user_id','audience_capicity','length','turns_no','description','best_record_hours','best_record_minutes','best_record_seconds','fia_grade','type','category_id' , 'event_maker_id' ,'category_ids'];
    
    protected $casts = ['lat' => 'decimal:8' , 'lng' => 'decimal:8'];


    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }
    public function sponsor()
    {
        return $this->belongsTo(User::class, 'sponsor_id', 'id');
    }
    public function partner()
    {
        return $this->belongsTo(User::class, 'partner_id', 'id');
    }
}
