<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Event;
use App\Models\Setting;
use Illuminate\Http\Request;

class SettingController extends Controller
{
    public function get_about_app()
    {
        $about = Setting::select('about_app_title as title' ,'about_app_body as body')->first();
        return $this->apiResponse(200 , null , $about);
    }

    public function get_terms_and_conditions()
    {
        $terms = Setting::select('terms_and_condition_title as title','terms_and_conditions_body as body')->first();
        return  $this->apiResponse(200 , null , $terms);
    }

    public function get_privacy_policy()
    {
        $privacy = Setting::select('privacy_policy_title as title','privacy_policy_body as body')->first();
        return  $this->apiResponse(200 , null , $privacy);
    }

    public function get_events()
    {
        $events = Event::get();
        return  $this->apiResponse(200 , null , $events);
    }
}
