<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\UserResource;
use App\Models\Chat;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class ChatController extends Controller
{

    public function chat_messages(Request $request)
    {
        $user = auth()->user();

        $sender_id=$user->id;

        $receiver_id = $request->receiver_id;

        $messages =  Chat::select('id','created_at', 'media' , 'type' ,'message','sender_id','receiver_id')->where(function($query) use ($sender_id, $receiver_id)
        {
            $query->where('sender_id', $receiver_id)
        ->where('receiver_id',$sender_id);
        })
        ->orWhere(function($query) use ($sender_id, $receiver_id)
        {
            $query->where('sender_id', $sender_id)
        ->where('receiver_id',$receiver_id);
        })->get();

        foreach($messages as $message){
            $message->added_at = $message->created_at->diffForHumans();
            $message->media = asset('images/').'/'.  $message->media;
        }


        return $this->apiResponse(200 , null ,$messages);
    }

    public function chat_history()
    {

        $user = auth()->user();

        $messages =  Chat::select('created_at','message','sender_id','receiver_id','created_at')->where('sender_id',$user->id)->orWhere('receiver_id',$user->id)->latest()->get();

        $temp_users = array();
        $sent_data=array();

        $selected_user = 0;

        foreach($messages as $message){


            if($user->id == $message->sender_id )
            $selected_user = $message->receiver_id ;
            else
            $selected_user = $message->sender_id ;

            $message->user = User::select('id','image','name')->where('id',$selected_user)->first();

            $message->user->image = asset('images/').'/'.  $message->user->image;

            if(!in_array($selected_user,$temp_users)){
            array_push($sent_data,$message);
            array_push($temp_users,$selected_user);
            }

            $message->added_at = $message->created_at->diffForHumans();
        }

            return $this->apiResponse(200, "test", $sent_data);
    }



    public function send_message(Request $request)
    {
        $user = auth()->user();

        $chat =  Chat::create([
          'sender_id' =>  $user->id ,
          'receiver_id' => $request->receiver_id ,
          'message' => $request->message,
        ]);

        if($request->hasFile('media')){

            $media = $request->file('media');
            $media_name =  Time().'-'.$media->getClientOriginalName();
            $path = public_path().'/images';
            $media->move($path,$media_name);

            $chat->type = $request->type;
            $chat->media = $media_name;
            $chat->save();
        }

        return $this->apiResponse(200, 'message is sent', null);

    }

}
